/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network.syncable;

import fr.frinn.custommachinery.common.network.data.FluidStackData;
import fr.frinn.custommachinery.impl.network.AbstractSyncable;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.neoforged.neoforge.fluids.FluidStack;

public abstract class FluidStackSyncable
extends AbstractSyncable<FluidStackData, FluidStack> {
    @Override
    public FluidStackData getData(short id) {
        return new FluidStackData(id, (FluidStack)this.get());
    }

    @Override
    public boolean needSync() {
        FluidStack value = (FluidStack)this.get();
        boolean needSync = this.lastKnownValue != null ? !FluidStack.matches((FluidStack)value, (FluidStack)((FluidStack)this.lastKnownValue)) : true;
        this.lastKnownValue = value.copy();
        return needSync;
    }

    public static FluidStackSyncable create(final Supplier<FluidStack> supplier, final Consumer<FluidStack> consumer) {
        return new FluidStackSyncable(){

            @Override
            public FluidStack get() {
                return (FluidStack)supplier.get();
            }

            @Override
            public void set(FluidStack value) {
                consumer.accept(value);
            }
        };
    }
}

