/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.requirement;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.crafting.IRequirementList;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientRequirement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.api.requirement.RecipeRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.client.integration.jei.wrapper.ExperienceIngredientWrapper;
import fr.frinn.custommachinery.common.component.ExperienceMachineComponent;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.impl.integration.jei.Experience;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;

public record ExperienceRequirement(RequirementIOMode mode, int amount, Experience.Form form) implements IRequirement<ExperienceMachineComponent>,
IJEIIngredientRequirement<Experience>
{
    public static final NamedCodec<ExperienceRequirement> CODEC = NamedCodec.record(experienceRequirementInstance -> experienceRequirementInstance.group(RequirementIOMode.CODEC.fieldOf("mode").forGetter(ExperienceRequirement::getMode), NamedCodec.INT.fieldOf("amount").forGetter(ExperienceRequirement::amount), NamedCodec.enumCodec(Experience.Form.class).optionalFieldOf("form", Experience.Form.POINT).forGetter(ExperienceRequirement::form)).apply((Applicative)experienceRequirementInstance, ExperienceRequirement::new), "Experience requirement");

    @Override
    public RequirementType<ExperienceRequirement> getType() {
        return Registration.EXPERIENCE_REQUIREMENT.get();
    }

    @Override
    public MachineComponentType<ExperienceMachineComponent> getComponentType() {
        return Registration.EXPERIENCE_MACHINE_COMPONENT.get();
    }

    @Override
    public RequirementIOMode getMode() {
        return this.mode;
    }

    @Override
    public boolean test(ExperienceMachineComponent component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.amount, this, null);
        if (this.form.isPoint()) {
            if (this.getMode() == RequirementIOMode.INPUT) {
                return component.extractXp(amount, true) == amount;
            }
            return component.receiveXp(amount, true) == amount;
        }
        if (this.getMode() == RequirementIOMode.INPUT) {
            return component.extractLevel(amount, true) == amount;
        }
        return component.receiveLevel(amount, true) == amount;
    }

    @Override
    public void gatherRequirements(IRequirementList<ExperienceMachineComponent> list) {
        if (this.mode == RequirementIOMode.INPUT) {
            list.processOnStart(this::processInputs);
        } else {
            list.processOnEnd(this::processOutputs);
        }
    }

    private CraftingResult processInputs(ExperienceMachineComponent component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.amount, this, null);
        if (this.form.isPoint()) {
            int canExtract = component.extractXp(amount, true);
            if (canExtract == amount) {
                component.extractXp(amount, false);
                return CraftingResult.success();
            }
            return CraftingResult.error((Component)Component.translatable((String)"custommachinery.requirements.xp.point.error.input", (Object[])new Object[]{amount, canExtract}));
        }
        int canExtract = component.extractLevel(amount, true);
        if (canExtract == amount) {
            component.extractLevel(amount, false);
            return CraftingResult.success();
        }
        return CraftingResult.error((Component)Component.translatable((String)"custommachinery.requirements.xp.level.error.input", (Object[])new Object[]{amount, canExtract}));
    }

    private CraftingResult processOutputs(ExperienceMachineComponent component, ICraftingContext context) {
        int amount = (int)context.getIntegerModifiedValue(this.amount, this, null);
        if (this.form.isPoint()) {
            int canReceive = component.receiveXp(amount, true);
            if (canReceive == amount) {
                component.receiveXp(amount, false);
                return CraftingResult.success();
            }
            return CraftingResult.error((Component)Component.translatable((String)"custommachinery.requirements.xp.point.error.output", (Object[])new Object[]{amount}));
        }
        int canReceive = component.receiveLevel(amount, true);
        if (canReceive == amount) {
            component.receiveLevel(amount, false);
            return CraftingResult.success();
        }
        return CraftingResult.error((Component)Component.translatable((String)"custommachinery.requirements.xp.level.error.output", (Object[])new Object[]{amount}));
    }

    @Override
    public List<IJEIIngredientWrapper<Experience>> getJEIIngredientWrappers(IMachineRecipe recipe, RecipeRequirement<?, ?> requirement) {
        return Collections.singletonList(new ExperienceIngredientWrapper(this.getMode(), this.amount, requirement.chance(), false, recipe.getRecipeTime(), this.form));
    }
}

