/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.ICustomMachineryAPI;
import fr.frinn.custommachinery.api.component.IMachineComponent;
import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.guielement.IComponentGuiElement;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.requirement.RecipeRequirement;
import fr.frinn.custommachinery.common.component.item.ItemMachineComponent;
import fr.frinn.custommachinery.common.crafting.craft.CustomCraftRecipe;
import fr.frinn.custommachinery.common.crafting.machine.CustomMachineRecipe;
import fr.frinn.custommachinery.common.guielement.SlotGuiElement;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.upgrade.MachineUpgrade;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import org.apache.logging.log4j.Logger;

public class CMVerifier {
    public static int verify(RecipeManager manager) {
        Logger logger = ICustomMachineryAPI.INSTANCE.logger();
        AtomicInteger errors = new AtomicInteger();
        logger.info("---------------------------------------------");
        logger.info("| Starting verification of Custom Machinery |");
        logger.info("---------------------------------------------");
        logger.info("Found {} custom machines : ", (Object)CustomMachinery.MACHINES.size());
        CustomMachinery.MACHINES.forEach((id, machine) -> {
            logger.info(" - {}", (Object)id.toString());
            errors.addAndGet(CMVerifier.verifyMachine(logger, machine));
        });
        logger.info("Found {} custom machine upgrades", (Object)CustomMachinery.UPGRADES.getAllUpgrades().size());
        CustomMachinery.UPGRADES.getAllUpgrades().forEach(upgrade -> {
            logger.info(" - {}", (Object)BuiltInRegistries.ITEM.getKey((Object)upgrade.getItem()).toString());
            errors.addAndGet(CMVerifier.verifyUpgrade(logger, upgrade));
        });
        List machineRecipes = manager.getAllRecipesFor((RecipeType)Registration.CUSTOM_MACHINE_RECIPE.get());
        logger.info("Found {} custom machine recipes", (Object)machineRecipes.size());
        machineRecipes.forEach(holder -> {
            logger.info(" - {}", (Object)holder.id().toString());
            errors.addAndGet(CMVerifier.verifyMachineRecipe(logger, (CustomMachineRecipe)holder.value()));
        });
        List craftRecipes = manager.getAllRecipesFor((RecipeType)Registration.CUSTOM_CRAFT_RECIPE.get());
        logger.info("Found {} custom craft recipes", (Object)craftRecipes.size());
        craftRecipes.forEach(holder -> {
            logger.info(" - {}", (Object)holder.id().toString());
            errors.addAndGet(CMVerifier.verifyCraftRecipe(logger, (CustomCraftRecipe)holder.value()));
        });
        return errors.get();
    }

    private static int verifyMachine(Logger logger, CustomMachine machine) {
        int errors = 0;
        for (IMachineComponentTemplate<? extends IMachineComponent> template2 : machine.getComponentTemplates()) {
            for (IMachineComponentTemplate<? extends IMachineComponent> iMachineComponentTemplate : machine.getComponentTemplates()) {
                if (template2 == iMachineComponentTemplate || template2.getType() != iMachineComponentTemplate.getType() || !template2.getId().equals(iMachineComponentTemplate.getId())) continue;
                logger.error(" - Multiple machine components of type {} have the same id '{}'", (Object)template2.getType().getId().toString(), (Object)template2.getId());
                ++errors;
            }
        }
        for (IGuiElement element : machine.getGuiElements()) {
            for (IGuiElement iGuiElement : machine.getGuiElements()) {
                if (element == iGuiElement || element.getType() != iGuiElement.getType() || !element.getId().equals(iGuiElement.getId()) || element.getId().isEmpty()) continue;
                logger.error(" - Multiple gui elements of type {} have the same id '{}'", (Object)element.getType().getId().toString(), (Object)element.getId());
                ++errors;
            }
        }
        for (IGuiElement element : machine.getGuiElements()) {
            if (element instanceof SlotGuiElement) {
                SlotGuiElement slotGuiElement = (SlotGuiElement)element;
                if (machine.getComponentTemplates().stream().noneMatch(template -> template instanceof ItemMachineComponent.Template && template.getId().equals(slotGuiElement.getComponentId()))) {
                    logger.error(" - Slot gui element of id '{}' doesn't have an associated machine component", (Object)slotGuiElement.getComponentType().getId().toString(), (Object)slotGuiElement.getComponentId());
                }
            }
            if (element.getType() == Registration.SLOT_GUI_ELEMENT.get() || !(element instanceof IComponentGuiElement)) continue;
            IComponentGuiElement componentGuiElement = (IComponentGuiElement)((Object)element);
            if (!machine.getComponentTemplates().stream().noneMatch(template -> template.getType() == componentGuiElement.getComponentType() && template.getId().equals(componentGuiElement.getComponentId()))) continue;
            logger.error(" - Gui element of type {} and id '{}' doesn't have an associated machine component", (Object)componentGuiElement.getComponentType().getId().toString(), (Object)componentGuiElement.getComponentId());
        }
        boolean crafter = machine.getProcessorTemplate().getType() == Registration.CRAFT_PROCESSOR.get();
        for (IMachineComponentTemplate<? extends IMachineComponent> template3 : machine.getComponentTemplates()) {
            if (template3.getType() != Registration.ITEM_RESULT_MACHINE_COMPONENT.get() || crafter) continue;
            logger.error(" - Found item component of type {} with id '{}' but machine isn't using craft processor !\nResult item components should only be used for machines with craft processor, consider using item component type {} instead.", (Object)template3.getType().getId().toString(), (Object)template3.getId(), (Object)Registration.ITEM_MACHINE_COMPONENT.get().getId().toString());
            ++errors;
        }
        if (crafter && machine.getComponentTemplates().stream().noneMatch(template -> template.getType() == Registration.ITEM_RESULT_MACHINE_COMPONENT.get())) {
            logger.error(" - No result item machine component found but machine is using craft processor !\nAt least 1 item component of type {} is required for the craft processor to work correctly.", (Object)Registration.ITEM_RESULT_MACHINE_COMPONENT.get().getId().toString());
            ++errors;
        }
        return errors;
    }

    private static int verifyUpgrade(Logger logger, MachineUpgrade upgrade) {
        int errors = 0;
        for (ResourceLocation id : upgrade.getMachines()) {
            if (CustomMachinery.MACHINES.containsKey(id)) continue;
            logger.error(" - Unknown machine id {} specified for this upgrade", (Object)id.toString());
            ++errors;
        }
        if (upgrade.getModifiers().isEmpty()) {
            logger.error(" - Upgrade doesn't have any modifiers");
            ++errors;
        }
        return errors;
    }

    private static int verifyMachineRecipe(Logger logger, CustomMachineRecipe recipe) {
        int errors = 0;
        CustomMachine machine = CustomMachinery.MACHINES.get(recipe.getMachineId());
        if (machine == null) {
            logger.error(" - Unknown machine id: {}", (Object)recipe.getMachineId());
            return 1;
        }
        if (machine.getProcessorTemplate().getType() != Registration.MACHINE_PROCESSOR.get()) {
            logger.error(" - Recipe can't be processed by machine {} as it doesn't use machine processor");
            ++errors;
        }
        if (recipe.getRequirements().isEmpty() && recipe.getJeiRequirements().isEmpty()) {
            logger.error(" - Recipe doesn't have any requirements");
            ++errors;
        }
        for (RecipeRequirement<?, ?> requirement : recipe.getRequirements()) {
            if (requirement.requirement().getComponentType().isDefaultComponent() || !machine.getComponentTemplates().stream().noneMatch(template -> template.getType() == requirement.requirement().getComponentType())) continue;
            logger.error(" - Recipe has a requirement of type {} but machine doesn't have a component of type {}", (Object)requirement.requirement().getType().getId().toString(), (Object)requirement.requirement().getComponentType().getId().toString());
            ++errors;
        }
        return errors;
    }

    private static int verifyCraftRecipe(Logger logger, CustomCraftRecipe recipe) {
        int errors = 0;
        CustomMachine machine = CustomMachinery.MACHINES.get(recipe.getMachineId());
        if (machine == null) {
            logger.error(" - Unknown machine id: {}", (Object)recipe.getMachineId());
            return 1;
        }
        if (machine.getProcessorTemplate().getType() != Registration.CRAFT_PROCESSOR.get()) {
            logger.error(" - Recipe can't be processed by machine {} as it doesn't use craft processor");
            ++errors;
        }
        if (recipe.getRequirements().isEmpty() && recipe.getJeiRequirements().isEmpty()) {
            logger.error(" - Recipe doesn't have any requirements");
            ++errors;
        }
        for (RecipeRequirement<?, ?> requirement : recipe.getRequirements()) {
            if (requirement.requirement().getComponentType().isDefaultComponent() || !machine.getComponentTemplates().stream().noneMatch(template -> template.getType() == requirement.requirement().getComponentType())) continue;
            logger.error(" - Recipe has a requirement of type {} but machine doesn't have a component of type {}", (Object)requirement.requirement().getType().getId().toString(), (Object)requirement.requirement().getComponentType().getId().toString());
            ++errors;
        }
        return errors;
    }
}

