/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.RecordBuilder;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import fr.frinn.custommachinery.impl.codec.DefaultCodecs;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MachineShape
implements Function<Direction, VoxelShape> {
    private static final NamedCodec<List<AABB>> BOX_LIST_CODEC = new NamedCodec<List<AABB>>(){

        @Override
        public <T> DataResult<Pair<List<AABB>, T>> decode(DynamicOps<T> ops, T input) {
            DataResult<AABB> box = DefaultCodecs.BOX.read(ops, input);
            if (box.result().isPresent()) {
                return DataResult.success((Object)Pair.of(Collections.singletonList((AABB)box.result().get()), (Object)ops.empty()));
            }
            return DefaultCodecs.BOX.listOf().decode(ops, input);
        }

        @Override
        public <T> DataResult<T> encode(DynamicOps<T> ops, List<AABB> input, T prefix) {
            return DefaultCodecs.BOX.listOf().encode(ops, input, prefix);
        }

        @Override
        public String name() {
            return "BOX";
        }
    };
    private static final NamedCodec<Map<Direction, List<AABB>>> MAP_CODEC = NamedCodec.unboundedMap(DefaultCodecs.DIRECTION, BOX_LIST_CODEC, "Map<Direction, List<Box>>");
    public static final NamedCodec<MachineShape> CODEC = new NamedCodec<MachineShape>(){

        @Override
        public <T> DataResult<Pair<MachineShape, T>> decode(DynamicOps<T> ops, T input) {
            DataResult<PartialBlockState> block = PartialBlockState.CODEC.read(ops, input);
            if (block.result().isPresent()) {
                BlockState state = ((PartialBlockState)block.result().get()).getBlockState();
                EnumMap shapes = Maps.newEnumMap(Direction.class);
                try {
                    for (Direction side2 : Direction.values()) {
                        shapes.put(side2, state.getShape(null, null));
                    }
                }
                catch (Exception e) {
                    return DataResult.error(() -> "Can't mimic shape of block: " + String.valueOf(block.result().get()));
                }
                return DataResult.success((Object)Pair.of((Object)new MachineShape(shapes), (Object)ops.empty()));
            }
            DataResult<List<AABB>> boxes = BOX_LIST_CODEC.read(ops, input);
            if (boxes.result().isPresent()) {
                VoxelShape shape = MachineShape.fromAABBList((List)boxes.result().get());
                EnumMap shapes = Maps.newEnumMap(Direction.class);
                for (Direction side3 : Direction.values()) {
                    if (side3.getAxis() == Direction.Axis.Y) continue;
                    shapes.put(side3, MachineShape.rotateShape(Direction.NORTH, side3, shape));
                }
                return DataResult.success((Object)Pair.of((Object)new MachineShape(shapes), (Object)ops.empty()));
            }
            DataResult<Map<Direction, List<AABB>>> map = MAP_CODEC.read(ops, input);
            if (map.result().isPresent()) {
                EnumMap shapes = Maps.newEnumMap(Direction.class);
                ((Map)map.result().get()).forEach((side, box) -> shapes.put(side, MachineShape.fromAABBList(box)));
                return DataResult.success((Object)Pair.of((Object)new MachineShape(shapes), (Object)ops.empty()));
            }
            return DataResult.error(() -> "Can't parse block shape: " + String.valueOf(input));
        }

        @Override
        public <T> DataResult<T> encode(DynamicOps<T> ops, MachineShape input, T prefix) {
            RecordBuilder builder = ops.mapBuilder();
            input.shapes.forEach((side, shape) -> builder.add(side.getName(), BOX_LIST_CODEC.encodeStart(ops, shape.toAabbs())));
            return builder.build(prefix);
        }

        @Override
        public String name() {
            return "Machine Shape";
        }
    };
    public static final MachineShape DEFAULT = new MachineShape();
    public static final MachineShape DEFAULT_COLLISION = new MachineShape();
    private final Map<Direction, VoxelShape> shapes = Maps.newEnumMap(Direction.class);

    public MachineShape() {
        for (Direction side : Direction.values()) {
            this.shapes.put(side, Shapes.block());
        }
    }

    public MachineShape(Map<Direction, VoxelShape> shapes) {
        this.shapes.putAll(shapes);
    }

    @Override
    public VoxelShape apply(Direction side) {
        return this.shapes.get(side);
    }

    private static VoxelShape fromAABBList(List<AABB> list) {
        VoxelShape shape = Shapes.empty();
        for (AABB box : list) {
            VoxelShape partial = Shapes.create((AABB)box);
            shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)partial, (BooleanOp)BooleanOp.OR);
        }
        return shape;
    }

    private static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        if (from == to) {
            return shape;
        }
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.empty()};
        int times = (to.get2DDataValue() - from.get2DDataValue() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.box((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.empty();
        }
        return buffer[0];
    }
}

