/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.impl.component.config;

import fr.frinn.custommachinery.api.component.ISideConfigComponent;
import fr.frinn.custommachinery.common.util.Color;
import fr.frinn.custommachinery.impl.component.config.RelativeSide;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import org.apache.logging.log4j.util.TriConsumer;

public abstract class SideConfig<M extends SideMode> {
    public static final Color DEFAULT_COLOR = Color.fromColors(0.5, 0.0, 0.0, 1.0);
    final Map<RelativeSide, M> sides = new EnumMap<RelativeSide, M>(RelativeSide.class);
    private final ISideConfigComponent component;
    private final Direction facing;
    private final boolean enabled;
    private final Color color;
    private TriConsumer<RelativeSide, M, M> callback;

    public SideConfig(ISideConfigComponent component, Map<RelativeSide, M> defaultConfig, boolean enabled, Color color) {
        this.component = component;
        this.facing = component != null ? component.getManager().facing() : Direction.NORTH;
        this.sides.putAll(defaultConfig);
        this.enabled = enabled;
        this.color = color;
    }

    public ISideConfigComponent getComponent() {
        return this.component;
    }

    public M getSideMode(RelativeSide side) {
        return (M)((SideMode)this.sides.get((Object)side));
    }

    public M getDirectionMode(Direction direction) {
        return this.getSideMode(RelativeSide.fromDirections(this.facing, direction));
    }

    public void setSideMode(RelativeSide side, M mode) {
        SideMode oldMode = (SideMode)this.sides.put(side, mode);
        if (this.callback != null && !this.getComponent().getManager().getLevel().isClientSide()) {
            this.callback.accept((Object)side, (Object)oldMode, mode);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Color getColor() {
        return this.color;
    }

    public void set(SideConfig<M> config) {
        for (RelativeSide side : RelativeSide.values()) {
            this.setSideMode(side, config.getSideMode(side));
        }
    }

    public void setCallback(TriConsumer<RelativeSide, M, M> callback) {
        this.callback = callback;
    }

    public abstract void setNext(RelativeSide var1);

    public abstract void setPrevious(RelativeSide var1);

    public abstract SideConfig<M> copy();

    public abstract CompoundTag serialize();

    public abstract void deserialize(CompoundTag var1);

    public static interface SideMode {
        public Component title();

        public int color();
    }

    public static interface Template<M extends SideMode> {
        public Map<RelativeSide, M> sides();

        public boolean enabled();

        public Color color();
    }
}

