/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.machine.MachineStatus;
import fr.frinn.custommachinery.api.network.IData;
import fr.frinn.custommachinery.client.integration.jei.CustomMachineryJEIPlugin;
import fr.frinn.custommachinery.client.screen.CustomMachineScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineCreationScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.common.init.CustomMachineContainer;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.machine.MachineAppearance;
import fr.frinn.custommachinery.common.machine.builder.CustomMachineBuilder;
import fr.frinn.custommachinery.common.network.SyncableContainer;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.Nullable;

public class ClientPacketHandler {
    public static void handleMachineStatusChangedPacket(BlockPos pos, MachineStatus status) {
        CustomMachineTile machineTile;
        BlockEntity tile;
        if (Minecraft.getInstance().level != null && (tile = Minecraft.getInstance().level.getBlockEntity(pos)) instanceof CustomMachineTile && status != (machineTile = (CustomMachineTile)tile).getStatus()) {
            machineTile.setStatus(status);
            machineTile.refreshClientData();
            Minecraft.getInstance().level.sendBlockUpdated(pos, tile.getBlockState(), tile.getBlockState(), 3);
        }
    }

    public static void handleRefreshCustomMachineTilePacket(BlockPos pos, ResourceLocation machine) {
        BlockEntity tile;
        if (Minecraft.getInstance().level != null && (tile = Minecraft.getInstance().level.getBlockEntity(pos)) instanceof CustomMachineTile) {
            CustomMachineTile machineTile = (CustomMachineTile)tile;
            machineTile.setId(machine);
            machineTile.refreshClientData();
            Minecraft.getInstance().level.sendBlockUpdated(pos, machineTile.getBlockState(), machineTile.getBlockState(), 3);
        }
    }

    public static void handleUpdateContainerPacket(int windowId, List<IData<?>> data) {
        AbstractContainerMenu abstractContainerMenu;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && (abstractContainerMenu = player.containerMenu) instanceof SyncableContainer) {
            SyncableContainer container = (SyncableContainer)abstractContainerMenu;
            if (player.containerMenu.containerId == windowId) {
                data.forEach(container::handleData);
            }
        }
    }

    public static void handleUpdateMachinesPacket(Map<ResourceLocation, CustomMachine> machines) {
        CustomMachinery.MACHINES.clear();
        CustomMachinery.MACHINES.putAll(machines);
        Minecraft mc = Minecraft.getInstance();
        CreativeModeTab.ItemDisplayParameters params = new CreativeModeTab.ItemDisplayParameters(mc.player.connection.enabledFeatures(), mc.player.canUseGameMasterBlocks() && (Boolean)mc.options.operatorItemsTab().get() != false, (HolderLookup.Provider)mc.level.registryAccess());
        Registration.CUSTOM_MACHINE_TAB.get().buildContents(params);
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof MachineCreationScreen) {
            MachineCreationScreen creationScreen = (MachineCreationScreen)screen;
            creationScreen.reloadList();
        }
        if (ModList.get().isLoaded("jei")) {
            CustomMachineryJEIPlugin.reloadMachines(machines);
        }
    }

    public static void handleUpdateMachineAppearancePacket(BlockPos pos, @Nullable MachineAppearance appearance) {
        BlockEntity tile;
        if (Minecraft.getInstance().level != null && (tile = Minecraft.getInstance().level.getBlockEntity(pos)) instanceof CustomMachineTile) {
            CustomMachineTile machineTile = (CustomMachineTile)tile;
            machineTile.setCustomAppearance(appearance);
            machineTile.refreshClientData();
            Minecraft.getInstance().level.sendBlockUpdated(pos, machineTile.getBlockState(), machineTile.getBlockState(), 3);
        }
    }

    public static void handleUpdateMachineGuiElementsPacket(BlockPos pos, List<IGuiElement> elements) {
        BlockEntity tile;
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null && (tile = mc.level.getBlockEntity(pos)) instanceof CustomMachineTile) {
            CustomMachineTile machineTile = (CustomMachineTile)tile;
            machineTile.setCustomGuiElements(elements);
            Screen screen = mc.screen;
            if (screen instanceof CustomMachineScreen) {
                CustomMachineScreen screen2 = (CustomMachineScreen)screen;
                screen2.resize(mc, mc.getWindow().getGuiScaledWidth(), mc.getWindow().getGuiScaledHeight());
                ((CustomMachineContainer)screen2.getMenu()).init();
            }
        }
    }

    public static void handleOpenCreationScreenPacket() {
        Minecraft.getInstance().setScreen((Screen)new MachineCreationScreen());
    }

    public static void handleOpenEditScreenPacket(ResourceLocation machineId) {
        CustomMachine machine = CustomMachinery.MACHINES.get(machineId);
        if (machine != null) {
            Minecraft.getInstance().setScreen((Screen)new MachineEditScreen(new MachineCreationScreen(), 288, 210, new CustomMachineBuilder(machine)));
        }
    }
}

