/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.integration.jei.element;

import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.integration.jei.IJEIElementRenderer;
import fr.frinn.custommachinery.common.guielement.TextGuiElement;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;

public class TextGuiElementJeiRenderer
implements IJEIElementRenderer<TextGuiElement> {
    @Override
    public void renderElementInJEI(GuiGraphics graphics, TextGuiElement element, IMachineRecipe recipe, int mouseX, int mouseY) {
        int posX = switch (element.getAlignment()) {
            case TextGuiElement.Alignment.CENTER -> element.getX() - Minecraft.getInstance().font.width(element.getText().getString()) / 2;
            case TextGuiElement.Alignment.RIGHT -> element.getX() - Minecraft.getInstance().font.width(element.getText().getString());
            default -> element.getX();
        };
        int posY = element.getY();
        graphics.pose().pushPose();
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        if (element.getWidth() >= 0) {
            scaleX = (float)element.getWidth() / (float)Minecraft.getInstance().font.width((FormattedText)element.getText());
        }
        if (element.getHeight() >= 0) {
            float f = element.getHeight();
            Objects.requireNonNull(Minecraft.getInstance().font);
            scaleY = f / 9.0f;
        }
        if (scaleX == 1.0f && scaleY != 1.0f) {
            scaleX = scaleY;
        } else if (scaleX != 1.0f && scaleY == 1.0f) {
            scaleY = scaleX;
        }
        if (scaleX != 1.0f) {
            graphics.pose().translate((float)element.getX(), (float)element.getY(), 0.0f);
            graphics.pose().scale(scaleX, scaleY, 1.0f);
            graphics.pose().translate((float)(-element.getX()), (float)(-element.getY()), 0.0f);
        }
        graphics.drawString(Minecraft.getInstance().font, element.getText(), posX, posY, 0);
        graphics.pose().popPose();
    }
}

