/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import fr.frinn.custommachinery.common.guielement.ProgressBarGuiElement;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ProgressArrowRenderer {
    public static void renderProgressArrow(GuiGraphics graphics, ProgressBarGuiElement element, int x, int y, double progress) {
        int width = element.getWidth();
        int height = element.getHeight();
        int filledWidth = (int)((double)width * Mth.clamp((double)Mth.map((double)progress, (double)element.getStart(), (double)element.getEnd(), (double)0.0, (double)1.0), (double)0.0, (double)1.0));
        int filledHeight = (int)((double)height * Mth.clamp((double)Mth.map((double)progress, (double)element.getStart(), (double)element.getEnd(), (double)0.0, (double)1.0), (double)0.0, (double)1.0));
        if (element.getEmptyTexture().equals((Object)ProgressBarGuiElement.BASE_EMPTY_TEXTURE) && element.getFilledTexture().equals((Object)ProgressBarGuiElement.BASE_FILLED_TEXTURE)) {
            graphics.pose().pushPose();
            if (element.getDirection() == ProgressBarGuiElement.Orientation.TOP || element.getDirection() == ProgressBarGuiElement.Orientation.BOTTOM) {
                width = element.getHeight();
                height = element.getWidth();
                filledWidth = (int)((double)width * Mth.clamp((double)Mth.map((double)progress, (double)element.getStart(), (double)element.getEnd(), (double)0.0, (double)1.0), (double)0.0, (double)1.0));
            }
            ProgressArrowRenderer.rotate(graphics.pose(), element.getDirection(), x, y, width, height);
            graphics.blit(element.getEmptyTexture(), 0, 0, 0.0f, 0.0f, width, height, width, height);
            graphics.blit(element.getFilledTexture(), 0, 0, 0.0f, 0.0f, filledWidth, height, width, height);
            graphics.pose().popPose();
        } else {
            graphics.blit(element.getEmptyTexture(), x, y, 0.0f, 0.0f, width, height, width, height);
            ResourceLocation filled = element.getFilledTexture();
            switch (element.getDirection()) {
                case RIGHT: {
                    graphics.blit(filled, x, y, 0.0f, 0.0f, filledWidth, height, width, height);
                    break;
                }
                case LEFT: {
                    graphics.blit(filled, x + width - filledWidth, y, (float)(width - filledWidth), 0.0f, filledWidth, height, width, height);
                    break;
                }
                case BOTTOM: {
                    graphics.blit(filled, x, y, 0.0f, 0.0f, width, filledHeight, width, height);
                    break;
                }
                case TOP: {
                    graphics.blit(filled, x, y + height - filledHeight, 0.0f, (float)(height - filledHeight), width, filledHeight, width, height);
                }
            }
        }
    }

    public static void rotate(PoseStack matrix, ProgressBarGuiElement.Orientation orientation, int posX, int posY, int width, int height) {
        switch (orientation) {
            case RIGHT: {
                matrix.translate((float)posX, (float)posY, 0.0f);
                break;
            }
            case LEFT: {
                matrix.mulPose(new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f), 180.0f));
                matrix.translate((float)(-width - posX), (float)(-height - posY), 0.0f);
                break;
            }
            case TOP: {
                matrix.mulPose(new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f), 270.0f));
                matrix.translate((float)(-width - posY), (float)posX, 0.0f);
                break;
            }
            case BOTTOM: {
                matrix.mulPose(new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f), 90.0f));
                matrix.translate((float)posY, (float)(-height - posX), 0.0f);
            }
        }
    }
}

