/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen;

import fr.frinn.custommachinery.api.component.IMachineComponent;
import fr.frinn.custommachinery.api.component.ISideConfigComponent;
import fr.frinn.custommachinery.api.guielement.IComponentGuiElement;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.CustomMachineScreen;
import fr.frinn.custommachinery.client.screen.popup.ComponentConfigPopup;
import fr.frinn.custommachinery.client.screen.widget.TexturedButton;
import fr.frinn.custommachinery.client.screen.widget.config.ComponentConfigButton;
import fr.frinn.custommachinery.common.guielement.ConfigGuiElement;
import fr.frinn.custommachinery.impl.component.config.SideConfig;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.joml.Vector2i;

public class MachineConfigScreen
extends BaseScreen {
    private final CustomMachineScreen parent;

    public MachineConfigScreen(CustomMachineScreen parent) {
        super((Component)Component.translatable((String)"custommachinery.gui.config.title", (Object[])new Object[]{parent.getMachine().getName()}), parent.getWidth(), parent.getHeight());
        this.parent = parent;
    }

    private List<IGuiElement> getConfigurableElements() {
        return this.parent.getTile().getGuiElements().stream().filter(element -> {
            ISideConfigComponent configComponent;
            Object patt0$temp;
            IComponentGuiElement componentElement;
            return element instanceof IComponentGuiElement && (componentElement = (IComponentGuiElement)((Object)element)).getComponent(this.parent.getTile().getComponentManager()).isPresent() && (patt0$temp = componentElement.getComponent(this.parent.getTile().getComponentManager()).get()) instanceof ISideConfigComponent && (configComponent = (ISideConfigComponent)patt0$temp).getConfig().isEnabled();
        }).toList();
    }

    private ISideConfigComponent getComponentFromElement(IGuiElement element) {
        if (element instanceof IComponentGuiElement) {
            IComponentGuiElement componentGuiElement = (IComponentGuiElement)((Object)element);
            Optional optionalComponent = componentGuiElement.getComponent(this.parent.getTile().getComponentManager());
            if (optionalComponent.isPresent()) {
                IMachineComponent component = (IMachineComponent)optionalComponent.get();
                if (component instanceof ISideConfigComponent) {
                    ISideConfigComponent sideConfigComponent = (ISideConfigComponent)component;
                    return sideConfigComponent;
                }
                throw new IllegalArgumentException("Component of type: " + String.valueOf(component.getType().getId()) + " is not side configurable.");
            }
            throw new IllegalArgumentException("Element of type: " + String.valueOf(element.getType().getId()) + " don't have a component in the machine: " + String.valueOf(this.parent.getMachine().getId()));
        }
        throw new IllegalArgumentException("Element of type: " + String.valueOf(element.getType().getId()) + " is not a component element.");
    }

    @Override
    protected void init() {
        super.init();
        this.parent.init(Minecraft.getInstance(), this.width, this.height);
        this.getConfigurableElements().forEach(element -> {
            SideConfig<?> config = this.getComponentFromElement((IGuiElement)element).getConfig();
            ComponentConfigPopup popup = new ComponentConfigPopup(this, config);
            this.addRenderableWidget((GuiEventListener)new ComponentConfigButton(this.x + element.getX(), this.y + element.getY(), element.getWidth(), element.getHeight(), (Component)Component.translatable((String)"custommachinery.gui.config.tooltip"), button -> {
                this.closePopup(popup);
                this.openPopup(popup);
                Vector2i pos = MachineConfigScreen.getStartingPos(this.getConfigurableElements().indexOf(element));
                popup.move(pos.x * 20, pos.y * 20);
            }, config.getColor()));
        });
        this.parent.getTile().getGuiElements().stream().filter(element -> element instanceof ConfigGuiElement).findFirst().map(element -> (ConfigGuiElement)element).ifPresent(element -> this.addRenderableWidget((GuiEventListener)TexturedButton.builder((Component)Component.translatable((String)"custommachinery.gui.config.exit"), element.getTexture(), button -> Minecraft.getInstance().setScreen((Screen)this.parent)).bounds(this.x + element.getX(), this.y + element.getY(), element.getWidth(), element.getHeight()).hovered(element.getTextureHovered()).tooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.config.exit"))).build()));
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.pose().pushPose();
        this.parent.render(graphics, Integer.MAX_VALUE, Integer.MAX_VALUE, partialTicks);
        graphics.pose().translate(0.0f, 0.0f, 400.0f);
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.pose().popPose();
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (Minecraft.getInstance().options.keyInventory.matches(keyCode, scanCode) || keyCode == 256) {
            Minecraft.getInstance().setScreen((Screen)this.parent);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private static Vector2i getStartingPos(int np) {
        int dx = 0;
        int dy = 1;
        int segment_length = 1;
        int x = 0;
        int y = 0;
        int segment_passed = 0;
        if (np == 0) {
            return new Vector2i();
        }
        for (int n = 0; n < np; ++n) {
            x += dx;
            y += dy;
            if (++segment_passed != segment_length) continue;
            segment_passed = 0;
            int buffer = dy;
            dy = -dx;
            dx = buffer;
            if (dx != 0) continue;
            ++segment_length;
        }
        return new Vector2i(x, y);
    }
}

