/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation;

import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.popup.InfoPopup;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import fr.frinn.custommachinery.client.screen.widget.ComponentEditBox;
import fr.frinn.custommachinery.common.machine.MachineLocation;
import fr.frinn.custommachinery.common.network.CAddMachinePacket;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.TutorialToast;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.PacketDistributor;

public class CreateMachinePopup
extends PopupScreen {
    private Button create;
    private Button cancel;
    private EditBox id;
    private ComponentEditBox name;
    private CycleButton<MachineLocation.Loader> loader;

    protected CreateMachinePopup(BaseScreen parent) {
        super(parent, 128, 121);
    }

    public void create() {
        PacketDistributor.sendToServer((CustomPacketPayload)new CAddMachinePacket(this.id.getValue(), this.name.getComponent(), this.loader.getValue() == MachineLocation.Loader.KUBEJS), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.parent.closePopup(this);
        if (this.loader.getValue() == MachineLocation.Loader.DEFAULT) {
            this.parent.openPopup(new InfoPopup(this.parent, 144, 96).text(new Component[]{Component.translatable((String)"custommachinery.gui.creation.popup.create.success.description")}));
        } else if (this.loader.getValue() == MachineLocation.Loader.KUBEJS) {
            Minecraft.getInstance().getTutorial().addTimedToast(new TutorialToast(TutorialToast.Icons.MOUSE, (Component)Component.translatable((String)"custommachinery.gui.creation.popup.create.success"), null, false), 50);
        }
    }

    @Override
    protected void init() {
        super.init();
        GridLayout layout = new GridLayout(this.x, this.y).rowSpacing(5);
        GridLayout.RowHelper row = layout.createRowHelper(2);
        LayoutSettings center = row.newCellSettings().alignHorizontallyCenter();
        row.addChild((LayoutElement)new StringWidget(this.xSize, 10, (Component)Component.translatable((String)"custommachinery.gui.creation.popup.create"), this.font), 2, row.newCellSettings().alignHorizontallyCenter().paddingTop(5));
        this.id = (EditBox)row.addChild((LayoutElement)new EditBox(this.font, this.x + 10, this.y + 20, this.xSize - 20, 20, (Component)Component.literal((String)"machine_id")), 2, center);
        this.id.setFilter(s -> {
            if (s.contains(":")) {
                return ResourceLocation.tryParse((String)s) != null;
            }
            for (char c : s.toCharArray()) {
                if (ResourceLocation.validPathChar((char)c)) continue;
                return false;
            }
            return true;
        });
        this.id.setHint((Component)Component.literal((String)"machine_id"));
        this.id.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.popup.create.id.tooltip")));
        this.name = (ComponentEditBox)row.addChild((LayoutElement)new ComponentEditBox(this.x + 10, this.y + 43, this.xSize - 20, 20, (Component)Component.literal((String)"Machine name")), 2, center);
        this.name.setHint((Component)Component.literal((String)"Machine name"));
        this.name.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.popup.create.name.tooltip")));
        CycleButton.Builder builder = CycleButton.builder(MachineLocation.Loader::getTranslatedName).withValues((Object[])new MachineLocation.Loader[]{MachineLocation.Loader.DEFAULT}).withInitialValue((Object)MachineLocation.Loader.DEFAULT).displayOnlyValue();
        if (ModList.get().isLoaded("kubejs")) {
            builder.withValues((Object[])new MachineLocation.Loader[]{MachineLocation.Loader.DEFAULT, MachineLocation.Loader.KUBEJS});
        }
        builder.withTooltip(loader -> Tooltip.create((Component)Component.translatable((String)("custommachinery.gui.creation.popup.create.loader." + loader.name().toLowerCase(Locale.ROOT)))));
        this.loader = (CycleButton)row.addChild((LayoutElement)builder.create(0, 0, this.xSize - 20, 20, (Component)Component.empty()), 2, center);
        this.create = (Button)row.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"custommachinery.gui.creation.create").withStyle(ChatFormatting.GREEN), button -> this.create()).bounds(0, 0, 50, 20).build(), center);
        this.cancel = (Button)row.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"custommachinery.gui.popup.cancel").withStyle(ChatFormatting.DARK_RED), button -> this.parent.closePopup(this)).bounds(0, 0, 50, 20).build(), center);
        layout.arrangeElements();
        layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.create.active = !this.id.getValue().isEmpty() || ResourceLocation.tryParse((String)("custommachinery:" + this.id.getValue())) == null || !this.name.getValue().isEmpty();
    }
}

