/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineCreationScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineEditTabNavigationBar;
import fr.frinn.custommachinery.client.screen.creation.MachineTabManager;
import fr.frinn.custommachinery.client.screen.creation.tabs.AppearanceTab;
import fr.frinn.custommachinery.client.screen.creation.tabs.BaseInfoTab;
import fr.frinn.custommachinery.client.screen.creation.tabs.ComponentTab;
import fr.frinn.custommachinery.client.screen.creation.tabs.GuiTab;
import fr.frinn.custommachinery.client.screen.creation.tabs.TooltipsTab;
import fr.frinn.custommachinery.client.screen.popup.ConfirmPopup;
import fr.frinn.custommachinery.common.machine.builder.CustomMachineBuilder;
import fr.frinn.custommachinery.common.network.CEditMachinePacket;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.TabManager;
import net.minecraft.client.gui.components.toasts.TutorialToast;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;

public class MachineEditScreen
extends BaseScreen {
    public static final WidgetSprites SAVE_SPRITES = new WidgetSprites(CustomMachinery.rl("creation/save_button"), CustomMachinery.rl("creation/save_button_hovered"));
    public static final WidgetSprites CLOSE_SPRITES = new WidgetSprites(CustomMachinery.rl("creation/close_button"), CustomMachinery.rl("creation/close_button_hovered"));
    public static final WidgetSprites WIKI_SPRITES = new WidgetSprites(CustomMachinery.rl("creation/wiki_button"), CustomMachinery.rl("creation/wiki_button_hovered"));
    private final MachineCreationScreen parent;
    private final CustomMachineBuilder builder;
    private boolean changed = false;
    private ImageButton save;
    private ImageButton close;
    private ImageButton wiki;
    private TabManager tabManager;
    private MachineEditTabNavigationBar topBar;
    private MachineEditTabNavigationBar bottomBar;

    public MachineEditScreen(MachineCreationScreen parent, int xSize, int ySize, CustomMachineBuilder builder) {
        super((Component)Component.literal((String)"Machine edit"), xSize, ySize);
        this.parent = parent;
        this.builder = builder;
    }

    public CustomMachineBuilder getBuilder() {
        return this.builder;
    }

    public void setChanged() {
        this.changed = true;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void save() {
        this.changed = false;
        PacketDistributor.sendToServer((CustomPacketPayload)new CEditMachinePacket(this.builder.build()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        Minecraft.getInstance().getTutorial().addTimedToast(new TutorialToast(TutorialToast.Icons.MOUSE, (Component)Component.translatable((String)"custommachinery.gui.creation.save.toast"), null, false), 50);
    }

    public void cancel() {
        if (!this.changed) {
            Minecraft.getInstance().setScreen((Screen)new MachineCreationScreen());
        }
        ConfirmPopup popup = new ConfirmPopup(this, 128, 96, () -> Minecraft.getInstance().setScreen((Screen)new MachineCreationScreen()));
        popup.title((Component)Component.translatable((String)"custommachinery.gui.popup.warning").withStyle(ChatFormatting.DARK_RED));
        popup.text(new Component[]{Component.translatable((String)"custommachinery.gui.creation.popup.quit")});
        this.openPopup(popup, "close without editing");
    }

    public void wiki() {
        String[] s = SharedConstants.getCurrentVersion().getName().split("\\.");
        Object version = "1.19";
        if (s.length >= 2) {
            version = "1." + s[1];
        }
        Util.getPlatform().openUri("https://frinn.gitbook.io/custom-machinery-" + (String)version);
    }

    public TabManager getTabManager() {
        return this.tabManager;
    }

    @Override
    protected void init() {
        super.init();
        this.save = this.addRenderableWidget(new ImageButton(this.x - 28, this.y + 5, 20, 20, SAVE_SPRITES, button -> this.save()));
        this.save.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.save")));
        this.close = this.addRenderableWidget(new ImageButton(this.x - 28, this.y + 30, 20, 20, CLOSE_SPRITES, button -> this.cancel()));
        this.close.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.close")));
        this.wiki = this.addRenderableWidget(new ImageButton(this.x - 28, this.y + 55, 20, 20, WIKI_SPRITES, button -> this.wiki()));
        this.wiki.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.wiki")));
        this.tabManager = new MachineTabManager(this);
        this.topBar = this.addRenderableWidget(new MachineEditTabNavigationBar(this.xSize, this.tabManager, List.of(new BaseInfoTab(this), new AppearanceTab(this), new ComponentTab(this), new GuiTab(this)), false));
        this.topBar.selectTab(0, false);
        this.bottomBar = this.addRenderableWidget(new MachineEditTabNavigationBar(this.xSize, this.tabManager, List.of(new TooltipsTab(this)), true));
        this.repositionElements();
    }

    public void repositionElements() {
        this.save.setPosition(this.x - 28, this.y + 5);
        this.close.setPosition(this.x - 28, this.y + 30);
        this.wiki.setPosition(this.x - 28, this.y + 55);
        if (this.topBar == null) {
            return;
        }
        this.topBar.setRectangle(this.xSize - 10, 20, this.x + 5, this.y - 20);
        this.bottomBar.setRectangle((this.xSize - 10) / 4, 20, this.x + 5, this.y + this.ySize - 3);
        this.tabManager.setTabArea(new ScreenRectangle(this.x, this.y, this.xSize, this.ySize));
    }

    public <T extends GuiEventListener & Renderable> T addRenderableWidget(T widget) {
        return (T)super.addRenderableWidget(widget);
    }

    public void removeWidget(GuiEventListener listener) {
        super.removeWidget(listener);
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(graphics, mouseX, mouseY, partialTicks);
        MachineEditScreen.blankBackground(graphics, this.x, this.y, this.xSize, this.ySize);
        MachineEditScreen.blankBackground(graphics, this.x - 33, this.y, 30, 80);
    }

    public void onClose() {
        this.cancel();
    }
}

