/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.component;

import fr.frinn.custommachinery.client.screen.widget.ListWidget;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;

public class ComponentPropertyListWidget
extends ListWidget<ComponentPropertyEntry> {
    public ComponentPropertyListWidget(int x, int y, int width, int height, int itemHeight) {
        super(x, y, width, height, itemHeight, (Component)Component.empty());
    }

    public <T extends AbstractWidget> T add(Component title, T widget) {
        this.addEntry(new ComponentPropertyEntry(title, widget));
        return widget;
    }

    public static class ComponentPropertyEntry
    extends ListWidget.Entry {
        private final Component title;
        private final AbstractWidget widget;

        public ComponentPropertyEntry(Component title, AbstractWidget widget) {
            this.title = title;
            this.widget = widget;
        }

        @Override
        public void render(GuiGraphics graphics, int index, int x, int y, int width, int height, int mouseX, int mouseY, float partialTick) {
            Font font = Minecraft.getInstance().font;
            Objects.requireNonNull(Minecraft.getInstance().font);
            graphics.drawString(font, this.title, x, y + (height - 9) / 2, 0, false);
            this.widget.setPosition(x + width - this.widget.getWidth() - 10, y + (height - this.widget.getHeight()) / 2);
        }

        public List<? extends GuiEventListener> children() {
            return Collections.singletonList(this.widget);
        }
    }
}

