/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.gui;

import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.client.screen.creation.gui.GuiEditorWidget;
import fr.frinn.custommachinery.client.screen.creation.tabs.GuiTab;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import fr.frinn.custommachinery.client.screen.widget.IntegerEditBox;
import fr.frinn.custommachinery.client.screen.widget.SuggestedEditBox;
import fr.frinn.custommachinery.common.guielement.BackgroundGuiElement;
import fr.frinn.custommachinery.impl.util.TextureSizeHelper;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class BackgroundEditorPopup
extends PopupScreen {
    @Nullable
    private final BackgroundGuiElement background;
    private final GuiEditorWidget editor;
    private CycleButton<Mode> mode;
    private SuggestedEditBox texture;
    private IntegerEditBox width;
    private IntegerEditBox height;

    public BackgroundEditorPopup(MachineEditScreen parent, GuiEditorWidget editor) {
        super(parent, 256, 128);
        this.background = parent.getBuilder().getGuiElements().stream().filter(element -> element instanceof BackgroundGuiElement).map(element -> (BackgroundGuiElement)element).findFirst().orElse(null);
        this.editor = editor;
    }

    @Override
    protected void init() {
        super.init();
        Mode mode = Mode.CUSTOM;
        if (this.background == null || this.background.getTexture() == null) {
            mode = Mode.NO_BACKGROUND;
        } else if (this.background.getTexture().equals((Object)BackgroundGuiElement.BASE_BACKGROUND)) {
            mode = Mode.DEFAULT;
        }
        GridLayout layout = new GridLayout(this.x + 5, this.y + 5).spacing(5);
        GridLayout.RowHelper row = layout.createRowHelper(2);
        LayoutSettings center = row.newCellSettings().alignHorizontallyCenter();
        LayoutSettings middle = row.newCellSettings().alignVerticallyMiddle();
        Objects.requireNonNull(this.font);
        row.addChild((LayoutElement)new StringWidget(this.xSize - 10, 9, (Component)Component.translatable((String)"custommachinery.gui.creation.gui.background"), this.font), 2, center);
        row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.gui.background.mode"), this.font), middle);
        this.mode = (CycleButton)row.addChild((LayoutElement)CycleButton.builder(Mode::title).displayOnlyValue().withValues((Object[])Mode.values()).withInitialValue((Object)mode).create(0, 0, 100, 20, (Component)Component.translatable((String)"custommachinery.gui.creation.gui.background.mode"), (button, value) -> this.texture.setEditable(value == Mode.CUSTOM)));
        row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.gui.background.texture"), this.font), middle);
        this.texture = (SuggestedEditBox)row.addChild((LayoutElement)new SuggestedEditBox(this.font, 0, 0, 100, 20, (Component)Component.translatable((String)"custommachinery.gui.creation.gui.background.texture"), 5));
        this.texture.setMaxLength(Integer.MAX_VALUE);
        if (this.background != null) {
            this.texture.setValue(this.background.getTexture().toString());
            this.texture.hideSuggestions();
        }
        this.texture.addSuggestions(Minecraft.getInstance().getResourceManager().listResources("textures", id -> true).keySet().stream().map(ResourceLocation::toString).toList());
        this.texture.setEditable(mode == Mode.CUSTOM);
        row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.gui.background.width"), this.font), middle);
        this.width = (IntegerEditBox)row.addChild((LayoutElement)new IntegerEditBox(this.font, 0, 0, 100, 20, (Component)Component.translatable((String)"custommachinery.gui.creation.gui.background.width")));
        this.width.bounds(-1, 256);
        this.width.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.gui.background.width.tooltip")));
        if (this.background != null) {
            this.width.setValue("" + this.background.getWidth());
        } else {
            this.width.setValue("256");
        }
        row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.gui.background.height"), this.font), middle);
        this.height = (IntegerEditBox)row.addChild((LayoutElement)new IntegerEditBox(this.font, 0, 0, 100, 20, (Component)Component.translatable((String)"custommachinery.gui.creation.gui.background.height")));
        this.height.bounds(-1, 192);
        this.height.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.gui.background.height.tooltip")));
        if (this.background != null) {
            this.height.setValue("" + this.background.getHeight());
        } else {
            this.height.setValue("192");
        }
        row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.gui.background.show"), this.font), middle);
        Checkbox show = (Checkbox)row.addChild((LayoutElement)Checkbox.builder((Component)Component.translatable((String)"custommachinery.gui.creation.gui.background.show"), (Font)this.font).selected(this.editor.shouldShowBackground()).onValueChange((checkbox, value) -> this.editor.setShowBackground(value)).tooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.gui.background.show.tooltip"))).build());
        row.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"custommachinery.gui.creation.gui.background.close"), button -> this.close()).size(50, 20).build(), 2, center);
        layout.arrangeElements();
        layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.ySize = layout.getHeight() + 10;
    }

    private void close() {
        this.parent.closePopup(this);
    }

    @Override
    public void closed() {
        ResourceLocation texture;
        BaseScreen baseScreen = this.parent;
        if (!(baseScreen instanceof MachineEditScreen)) {
            return;
        }
        MachineEditScreen editScreen = (MachineEditScreen)baseScreen;
        if (this.mode.getValue() == Mode.NO_BACKGROUND) {
            Tab tab;
            if (this.background != null) {
                editScreen.getBuilder().getGuiElements().remove(this.background);
            }
            if ((tab = editScreen.getTabManager().getCurrentTab()) instanceof GuiTab) {
                GuiTab tab2 = (GuiTab)tab;
                int width = this.width.getIntValue() > 0 ? this.width.getIntValue() : 256;
                int height = this.height.getIntValue() > 0 ? this.height.getIntValue() : 192;
                tab2.setSize(width, height);
            }
            return;
        }
        switch (((Mode)((Object)this.mode.getValue())).ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                ResourceLocation resourceLocation = BackgroundGuiElement.BASE_BACKGROUND;
                break;
            }
            case 2: {
                ResourceLocation resourceLocation = ResourceLocation.tryParse((String)this.texture.getValue());
                break;
            }
            case 1: {
                ResourceLocation resourceLocation = texture = null;
            }
        }
        if (this.background != null) {
            editScreen.getBuilder().getGuiElements().remove(this.background);
            editScreen.getBuilder().getGuiElements().add(new BackgroundGuiElement(texture, this.width.getIntValue(), this.height.getIntValue()));
        } else {
            editScreen.getBuilder().getGuiElements().add(new BackgroundGuiElement(texture, this.width.getIntValue(), this.height.getIntValue()));
        }
        Tab height = editScreen.getTabManager().getCurrentTab();
        if (height instanceof GuiTab) {
            GuiTab tab = (GuiTab)height;
            int width = this.width.getIntValue() > 0 ? this.width.getIntValue() : TextureSizeHelper.getTextureWidth(texture);
            int height2 = this.height.getIntValue() > 0 ? this.height.getIntValue() : TextureSizeHelper.getTextureHeight(texture);
            tab.setSize(width, height2);
        }
    }

    public static enum Mode {
        DEFAULT((Component)Component.translatable((String)"custommachinery.gui.creation.gui.background.default")),
        NO_BACKGROUND((Component)Component.translatable((String)"custommachinery.gui.creation.gui.background.disabled")),
        CUSTOM((Component)Component.translatable((String)"custommachinery.gui.creation.gui.background.custom"));

        private final Component title;

        private Mode(Component title) {
            this.title = title;
        }

        public Component title() {
            return this.title;
        }
    }
}

