/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.gui;

import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.guielement.IMachineScreen;
import fr.frinn.custommachinery.api.machine.ICustomMachine;
import fr.frinn.custommachinery.api.machine.MachineTile;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.client.screen.creation.gui.GuiElementBuilderRegistry;
import fr.frinn.custommachinery.client.screen.creation.gui.IGuiElementBuilder;
import fr.frinn.custommachinery.client.screen.creation.gui.MutableProperties;
import fr.frinn.custommachinery.client.screen.popup.ConfirmPopup;
import fr.frinn.custommachinery.common.guielement.BackgroundGuiElement;
import fr.frinn.custommachinery.common.init.CustomMachineBlock;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Comparators;
import fr.frinn.custommachinery.impl.guielement.AbstractGuiElementWidget;
import fr.frinn.custommachinery.impl.guielement.GuiElementWidgetSupplierRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class GuiEditorWidget
extends AbstractWidget
implements ContainerEventHandler {
    private final MachineEditScreen parent;
    private final IMachineScreen dummyScreen = new DummyScreen();
    private final List<IGuiElement> elements = new ArrayList<IGuiElement>();
    private final List<WidgetEditorWidget<?>> widgets = new ArrayList();
    private final Button config;
    private final Button priorityUp;
    private final Button priorityDown;
    private final Button delete;
    private boolean dragging;
    private GuiEventListener focused;
    private static GridSettings gridSettings = new GridSettings(false, 10, 10, 0.5f);
    private static boolean showBackground = true;

    public GuiEditorWidget(MachineEditScreen parent, int x, int y, int width, int height, List<IGuiElement> baseElements) {
        super(x, y, width, height, (Component)Component.empty());
        this.parent = parent;
        baseElements.stream().sorted(Comparators.GUI_ELEMENTS_COMPARATOR.reversed()).forEach(this::addElement);
        this.config = Button.builder((Component)Component.empty(), button -> {
            GuiEventListener patt0$temp = this.getFocused();
            if (patt0$temp instanceof WidgetEditorWidget) {
                WidgetEditorWidget widget = (WidgetEditorWidget)patt0$temp;
                this.config(widget);
            }
        }).size(5, 5).tooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.gui.config"))).build();
        this.priorityUp = Button.builder((Component)Component.empty(), button -> this.changePriority(1)).size(5, 5).build();
        this.priorityDown = Button.builder((Component)Component.empty(), button -> this.changePriority(-1)).size(5, 5).build();
        this.delete = Button.builder((Component)Component.empty(), button -> this.delete()).size(5, 5).tooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.delete"))).build();
        this.hideButtons();
    }

    public void addElement(IGuiElement element) {
        if (!GuiElementWidgetSupplierRegistry.hasWidgetSupplier(element.getType()) || !GuiElementBuilderRegistry.hasBuilder(element.getType())) {
            return;
        }
        this.elements.add(element);
        this.widgets.add(this.getWidget(element));
    }

    public void addCreatedElement(IGuiElement element) {
        if (!GuiElementWidgetSupplierRegistry.hasWidgetSupplier(element.getType()) || !GuiElementBuilderRegistry.hasBuilder(element.getType())) {
            return;
        }
        this.elements.add(element);
        WidgetEditorWidget<IGuiElement> widget = this.getWidget(element);
        widget.setPosition(this.getX() + (this.getWidth() + widget.getWidth()) / 2, this.getY() + (this.getHeight() + widget.getHeight()) / 2);
        this.widgets.add(widget);
        this.setFocused((GuiEventListener)widget);
    }

    public void hideButtons() {
        this.config.visible = false;
        this.priorityUp.visible = false;
        this.priorityDown.visible = false;
        this.delete.visible = false;
    }

    public void showButtons(WidgetEditorWidget<?> widget) {
        this.config.setPosition(widget.getX() - 1, widget.getY() - 7);
        this.config.visible = true;
        this.priorityUp.setPosition(widget.getX() + 5, widget.getY() - 7);
        this.priorityUp.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.gui.priorityUp").append("\n").append((Component)Component.translatable((String)"custommachinery.gui.creation.gui.priority.value", (Object[])new Object[]{widget.properties.getPriority()}).withStyle(ChatFormatting.GRAY))));
        this.priorityUp.visible = true;
        this.priorityDown.setPosition(widget.getX() + 11, widget.getY() - 7);
        this.priorityDown.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.gui.priorityDown").append("\n").append((Component)Component.translatable((String)"custommachinery.gui.creation.gui.priority.value", (Object[])new Object[]{widget.properties.getPriority()}).withStyle(ChatFormatting.GRAY))));
        this.priorityDown.visible = true;
        this.delete.setPosition(widget.getX() + 17, widget.getY() - 7);
        this.delete.visible = true;
    }

    public <T extends IGuiElement> void config(WidgetEditorWidget<T> widget) {
        this.parent.openPopup(widget.builder.makeConfigPopup(this.parent, widget.properties, (IGuiElement)widget.widget.getElement(), widget::refreshWidget));
    }

    public GridSettings getGridSettings() {
        return gridSettings;
    }

    public void setGridSettings(GridSettings settings) {
        gridSettings = settings;
    }

    public boolean shouldShowBackground() {
        return showBackground;
    }

    public void setShowBackground(boolean show) {
        showBackground = show;
    }

    private void changePriority(int delta) {
        GuiEventListener guiEventListener = this.getFocused();
        if (guiEventListener instanceof WidgetEditorWidget) {
            WidgetEditorWidget widget = (WidgetEditorWidget)guiEventListener;
            widget.properties.setPriority(widget.properties.getPriority() + delta);
            widget.refreshWidget(null);
            List<WidgetEditorWidget> sorted = this.widgets.stream().sorted(Comparator.comparingInt(w -> w.properties.getPriority())).toList();
            this.widgets.clear();
            this.widgets.addAll(sorted);
            this.priorityUp.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.gui.priorityUp").append("\n").append((Component)Component.translatable((String)"custommachinery.gui.creation.gui.priority.value", (Object[])new Object[]{widget.properties.getPriority()}).withStyle(ChatFormatting.GRAY))));
            this.priorityDown.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.gui.priorityDown").append("\n").append((Component)Component.translatable((String)"custommachinery.gui.creation.gui.priority.value", (Object[])new Object[]{widget.properties.getPriority()}).withStyle(ChatFormatting.GRAY))));
            this.parent.setChanged();
        }
    }

    private void delete() {
        GuiEventListener guiEventListener = this.getFocused();
        if (guiEventListener instanceof WidgetEditorWidget) {
            WidgetEditorWidget widget = (WidgetEditorWidget)guiEventListener;
            ConfirmPopup popup = new ConfirmPopup(this.parent, 128, 96, () -> {
                this.widgets.remove((Object)widget);
                this.setFocused(null);
                this.parent.getBuilder().getGuiElements().remove(widget.widget.getElement());
                this.parent.setChanged();
            });
            popup.title((Component)Component.translatable((String)"custommachinery.gui.popup.warning").withStyle(ChatFormatting.DARK_RED));
            popup.text(new Component[]{Component.translatable((String)"custommachinery.gui.creation.gui.delete.popup")});
            this.parent.openPopup(popup);
        }
    }

    private <T extends IGuiElement> WidgetEditorWidget<T> getWidget(T element) {
        AbstractGuiElementWidget<? extends IGuiElement> widget = GuiElementWidgetSupplierRegistry.getWidgetSupplier(element.getType()).get(element, this.dummyScreen);
        IGuiElementBuilder<? extends IGuiElement> builder = GuiElementBuilderRegistry.getBuilder(element.getType());
        return new WidgetEditorWidget<IGuiElement>(widget, builder);
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        BackgroundGuiElement background;
        graphics.fill(this.getX() - 2, this.getY() - 2, this.getX() + this.getWidth() + 2, this.getY() + this.getHeight() + 2, FastColor.ARGB32.color((int)255, (int)0, (int)0, (int)0));
        graphics.fill(this.getX() - 1, this.getY() - 1, this.getX() + this.getWidth() + 1, this.getY() + this.getHeight() + 1, FastColor.ARGB32.color((int)255, (int)198, (int)198, (int)198));
        if (this.shouldShowBackground() && (background = (BackgroundGuiElement)this.parent.getBuilder().getGuiElements().stream().filter(element -> element instanceof BackgroundGuiElement).map(element -> (BackgroundGuiElement)element).findFirst().orElse(null)) != null && background.getTexture() != null) {
            graphics.blit(background.getTexture(), this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        }
        if (this.getGridSettings() != null && this.getGridSettings().enabled()) {
            for (int x = this.getX() + this.getGridSettings().xSpacing(); x < this.getX() + this.getWidth(); x += this.getGridSettings().xSpacing()) {
                graphics.fill(x, this.getY(), x + 1, this.getY() + this.getHeight(), FastColor.ARGB32.color((int)((int)(255.0f * this.getGridSettings().opacity())), (int)85, (int)85, (int)85));
            }
            for (int y = this.getY() + this.getGridSettings().ySpacing(); y < this.getY() + this.getHeight(); y += this.getGridSettings().ySpacing()) {
                graphics.fill(this.getX(), y, this.getX() + this.getWidth(), y + 1, FastColor.ARGB32.color((int)((int)(255.0f * this.getGridSettings().opacity())), (int)85, (int)85, (int)85));
            }
        }
        this.widgets.forEach(widget -> widget.render(graphics, mouseX, mouseY, partialTick));
        this.config.render(graphics, mouseX, mouseY, partialTick);
        this.priorityUp.render(graphics, mouseX, mouseY, partialTick);
        this.priorityDown.render(graphics, mouseX, mouseY, partialTick);
        this.delete.render(graphics, mouseX, mouseY, partialTick);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public void setX(int x) {
        super.setX(x);
        this.widgets.forEach(widget -> widget.setX(x + widget.widget.getElement().getX()));
        GuiEventListener guiEventListener = this.getFocused();
        if (guiEventListener instanceof WidgetEditorWidget) {
            WidgetEditorWidget widget2 = (WidgetEditorWidget)guiEventListener;
            this.hideButtons();
            this.showButtons(widget2);
        }
    }

    public void setY(int y) {
        super.setY(y);
        this.widgets.forEach(widget -> widget.setY(y + widget.widget.getElement().getY()));
        GuiEventListener guiEventListener = this.getFocused();
        if (guiEventListener instanceof WidgetEditorWidget) {
            WidgetEditorWidget widget2 = (WidgetEditorWidget)guiEventListener;
            this.hideButtons();
            this.showButtons(widget2);
        }
    }

    public List<? extends GuiEventListener> children() {
        return this.widgets;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDragging(boolean isDragging) {
        this.dragging = isDragging;
    }

    @Nullable
    public GuiEventListener getFocused() {
        return this.focused;
    }

    public void setFocused(@Nullable GuiEventListener focused) {
        if (this.focused != null) {
            this.focused.setFocused(false);
        }
        this.focused = focused;
        if (focused != null) {
            focused.setFocused(true);
        }
        if (focused instanceof WidgetEditorWidget) {
            WidgetEditorWidget widget = (WidgetEditorWidget)focused;
            this.showButtons(widget);
        } else {
            this.hideButtons();
        }
    }

    public Optional<GuiEventListener> getChildAt(double mouseX, double mouseY) {
        for (GuiEventListener guiEventListener : this.children()) {
            if (!guiEventListener.isMouseOver(mouseX, mouseY)) continue;
            return Optional.of(guiEventListener);
        }
        return Optional.empty();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.config.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.priorityUp.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.priorityDown.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.delete.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        for (GuiEventListener guiEventListener : this.widgets.reversed()) {
            if (!guiEventListener.mouseClicked(mouseX, mouseY, button)) continue;
            this.setFocused(guiEventListener);
            if (button == 0) {
                this.setDragging(true);
            }
            return true;
        }
        this.setFocused(null);
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.setDragging(false);
        return this.getFocused() != null && this.getFocused().mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.getFocused() != null && this.isDragging() && button == 0) {
            return this.getFocused().mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        return this.getChildAt(mouseX, mouseY).filter(arg -> arg.mouseScrolled(mouseX, mouseY, scrollX, scrollY)).isPresent();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return this.getFocused() != null && this.getFocused().keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        return this.getFocused() != null && this.getFocused().keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        return this.getFocused() != null && this.getFocused().charTyped(codePoint, modifiers);
    }

    private class DummyScreen
    implements IMachineScreen {
        private final MachineTile dummy = new CustomMachineTile(BlockPos.ZERO, ((CustomMachineBlock)((Object)Registration.CUSTOM_MACHINE_BLOCK.get())).defaultBlockState());

        private DummyScreen() {
        }

        @Override
        public int getX() {
            return GuiEditorWidget.this.getX();
        }

        @Override
        public int getY() {
            return GuiEditorWidget.this.getY();
        }

        @Override
        public int getWidth() {
            return GuiEditorWidget.this.getWidth();
        }

        @Override
        public int getHeight() {
            return GuiEditorWidget.this.getHeight();
        }

        @Override
        public MachineTile getTile() {
            return this.dummy;
        }

        @Override
        public ICustomMachine getMachine() {
            return this.dummy.getMachine();
        }
    }

    public class WidgetEditorWidget<T extends IGuiElement>
    extends AbstractWidget {
        private final IGuiElementBuilder<T> builder;
        private final MutableProperties properties;
        private AbstractGuiElementWidget<T> widget;
        private DragType dragType;
        private double dragX;
        private double dragY;

        public WidgetEditorWidget(AbstractGuiElementWidget<T> widget, IGuiElementBuilder<T> builder) {
            super(widget.getX(), widget.getY(), widget.getWidth(), widget.getHeight(), widget.getMessage());
            this.dragType = DragType.DEFAULT;
            this.dragX = 0.0;
            this.dragY = 0.0;
            this.widget = widget;
            this.builder = builder;
            this.properties = new MutableProperties(widget.getElement().getProperties());
        }

        public void refreshWidget(@Nullable T from) {
            T element = this.widget.getElement();
            T newElement = from != null ? from : this.builder.make(this.properties.build(), element);
            this.widget = GuiElementWidgetSupplierRegistry.getWidgetSupplier(element.getType()).get((IGuiElement)newElement, GuiEditorWidget.this.dummyScreen);
            this.widget.setPosition(this.getX(), this.getY());
            this.width = this.widget.getWidth();
            this.height = this.widget.getHeight();
            GuiEditorWidget.this.parent.getBuilder().getGuiElements().remove(element);
            GuiEditorWidget.this.parent.getBuilder().getGuiElements().add((IGuiElement)newElement);
        }

        private DragType getDragType(double mouseX, double mouseY) {
            if (!this.isMouseOver(mouseX, mouseY)) {
                return DragType.DEFAULT;
            }
            if (mouseX >= (double)this.getX() && mouseX <= (double)(this.getX() + 1) && mouseY >= (double)this.getY() && mouseY <= (double)(this.getY() + this.getHeight())) {
                return DragType.LEFT_RESIZE;
            }
            if (mouseX >= (double)(this.getX() + this.getWidth() - 1) && mouseX <= (double)(this.getX() + this.getWidth()) && mouseY >= (double)this.getY() && mouseY <= (double)(this.getY() + this.getHeight())) {
                return DragType.RIGHT_RESIZE;
            }
            if (mouseX >= (double)this.getX() && mouseX <= (double)(this.getX() + this.getWidth()) && mouseY >= (double)this.getY() && mouseY <= (double)(this.getY() + 1)) {
                return DragType.UP_RESIZE;
            }
            if (mouseX >= (double)this.getX() && mouseX <= (double)(this.getX() + this.getWidth()) && mouseY >= (double)(this.getY() + this.getHeight() - 1) && mouseY <= (double)(this.getY() + this.getHeight())) {
                return DragType.DOWN_RESIZE;
            }
            return DragType.DEFAULT;
        }

        private void checkCursorShape(int mouseX, int mouseY) {
            if (this.dragType != DragType.DEFAULT) {
                return;
            }
            switch (this.getDragType(mouseX, mouseY).ordinal()) {
                case 3: 
                case 4: {
                    GLFW.glfwSetCursor((long)Minecraft.getInstance().getWindow().getWindow(), (long)GLFW.glfwCreateStandardCursor((int)221189));
                    break;
                }
                case 1: 
                case 2: {
                    GLFW.glfwSetCursor((long)Minecraft.getInstance().getWindow().getWindow(), (long)GLFW.glfwCreateStandardCursor((int)221190));
                    break;
                }
                default: {
                    GLFW.glfwSetCursor((long)Minecraft.getInstance().getWindow().getWindow(), (long)GLFW.glfwCreateStandardCursor((int)221185));
                }
            }
        }

        protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            graphics.pose().pushPose();
            switch (this.dragType.ordinal()) {
                case 0: {
                    graphics.pose().translate(this.dragX, this.dragY, 0.0);
                    break;
                }
                case 3: {
                    graphics.pose().translate((double)(-this.getX()) * -this.dragX / (double)this.getWidth() + this.dragX, 0.0, 0.0);
                    graphics.pose().scale((float)(-this.dragX / (double)this.getWidth()) + 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 4: {
                    graphics.pose().translate((double)(-this.getX()) * this.dragX / (double)this.getWidth(), 0.0, 0.0);
                    graphics.pose().scale((float)(this.dragX / (double)this.getWidth()) + 1.0f, 1.0f, 1.0f);
                    break;
                }
                case 1: {
                    graphics.pose().translate(0.0, (double)(-this.getY()) * -this.dragY / (double)this.getHeight() + this.dragY, 0.0);
                    graphics.pose().scale(1.0f, (float)(-this.dragY / (double)this.getHeight()) + 1.0f, 1.0f);
                    break;
                }
                case 2: {
                    graphics.pose().translate(0.0, (double)(-this.getY()) * this.dragY / (double)this.getHeight(), 0.0);
                    graphics.pose().scale(1.0f, (float)(this.dragY / (double)this.getHeight()) + 1.0f, 1.0f);
                }
            }
            if (this.isFocused()) {
                graphics.fill(this.getX() - 1, this.getY() - 1, this.getX() + this.getWidth() + 1, this.getY() + this.getHeight() + 1, FastColor.ARGB32.color((int)255, (int)255, (int)0, (int)0));
                graphics.fill(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), FastColor.ARGB32.color((int)255, (int)198, (int)198, (int)198));
                this.checkCursorShape(mouseX, mouseY);
            }
            this.widget.render(graphics, Integer.MAX_VALUE, Integer.MAX_VALUE, partialTick);
            graphics.pose().popPose();
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }

        public void setX(int x) {
            super.setX(x);
            this.properties.setX(x - GuiEditorWidget.this.getX());
            this.refreshWidget(null);
        }

        public void setY(int y) {
            super.setY(y);
            this.properties.setY(y - GuiEditorWidget.this.getY());
            this.refreshWidget(null);
        }

        public void setWidth(int width) {
            super.setWidth(width);
            this.properties.setWidth(width);
            this.refreshWidget(null);
        }

        public void setHeight(int height) {
            this.height = height;
            this.properties.setHeight(height);
            this.refreshWidget(null);
        }

        public void onClick(double mouseX, double mouseY, int button) {
            this.dragType = this.getDragType(mouseX, mouseY);
            this.checkCursorShape((int)mouseX, (int)mouseY);
        }

        protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
            GuiEditorWidget.this.hideButtons();
            switch (this.dragType.ordinal()) {
                case 0: 
                case 1: 
                case 3: {
                    this.dragX = Mth.clamp((double)(this.dragX + dragX), (double)(GuiEditorWidget.this.getX() - this.getX()), (double)(GuiEditorWidget.this.getX() + GuiEditorWidget.this.getWidth() - this.getX() - this.getWidth()));
                    this.dragY = Mth.clamp((double)(this.dragY + dragY), (double)(GuiEditorWidget.this.getY() - this.getY()), (double)(GuiEditorWidget.this.getY() + GuiEditorWidget.this.getHeight() - this.getY() - this.getHeight()));
                    break;
                }
                case 4: {
                    this.dragX = Mth.clamp((double)(this.dragX + dragX), (double)(-this.getWidth()), (double)(GuiEditorWidget.this.getX() + GuiEditorWidget.this.getWidth() - this.getX() - this.getWidth()));
                    break;
                }
                case 2: {
                    this.dragY = Mth.clamp((double)(this.dragY + dragY), (double)(-this.getHeight()), (double)(GuiEditorWidget.this.getY() + GuiEditorWidget.this.getHeight() - this.getY() - this.getHeight()));
                }
            }
        }

        public void onRelease(double mouseX, double mouseY) {
            if (this.dragX == 0.0 && this.dragY == 0.0) {
                this.dragType = DragType.DEFAULT;
                return;
            }
            switch (this.dragType.ordinal()) {
                case 0: {
                    this.setX(this.getX() + (int)this.dragX);
                    this.setY(this.getY() + (int)this.dragY);
                    break;
                }
                case 3: {
                    this.setX(this.getX() + (int)this.dragX);
                    this.setWidth(this.getWidth() - (int)this.dragX);
                    break;
                }
                case 4: {
                    this.setWidth(this.getWidth() + (int)this.dragX);
                    break;
                }
                case 1: {
                    this.setY(this.getY() + (int)this.dragY);
                    this.setHeight(this.getHeight() - (int)this.dragY);
                    break;
                }
                case 2: {
                    this.setHeight(this.getHeight() + (int)this.dragY);
                }
            }
            GuiEditorWidget.this.showButtons(this);
            GuiEditorWidget.this.parent.setChanged();
            this.dragType = DragType.DEFAULT;
            this.dragX = 0.0;
            this.dragY = 0.0;
            GLFW.glfwSetCursor((long)Minecraft.getInstance().getWindow().getWindow(), (long)GLFW.glfwCreateStandardCursor((int)221185));
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            boolean moved;
            int move = Screen.hasShiftDown() ? 5 : (Screen.hasControlDown() ? 10 : 1);
            switch (keyCode) {
                case 263: {
                    this.setX(Math.max(this.getX() - move, GuiEditorWidget.this.getX()));
                    boolean bl = true;
                    break;
                }
                case 262: {
                    this.setX(Math.min(this.getX() + move, GuiEditorWidget.this.getX() + GuiEditorWidget.this.getWidth()));
                    boolean bl = true;
                    break;
                }
                case 265: {
                    this.setY(Math.max(this.getY() - move, GuiEditorWidget.this.getY()));
                    boolean bl = true;
                    break;
                }
                case 264: {
                    this.setY(Math.min(this.getY() + move, GuiEditorWidget.this.getY() + GuiEditorWidget.this.getHeight()));
                    boolean bl = true;
                    break;
                }
                case 261: {
                    GuiEditorWidget.this.delete();
                    boolean bl = true;
                    break;
                }
                default: {
                    boolean bl = moved = false;
                }
            }
            if (moved) {
                GuiEditorWidget.this.showButtons(this);
            }
            return moved;
        }
    }

    public record GridSettings(boolean enabled, int xSpacing, int ySpacing, float opacity) {
    }

    private static enum DragType {
        DEFAULT,
        UP_RESIZE,
        DOWN_RESIZE,
        LEFT_RESIZE,
        RIGHT_RESIZE;

    }
}

