/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.gui.builder;

import fr.frinn.custommachinery.api.guielement.GuiElementType;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.client.screen.creation.gui.GuiElementBuilderPopup;
import fr.frinn.custommachinery.client.screen.creation.gui.IGuiElementBuilder;
import fr.frinn.custommachinery.client.screen.creation.gui.MutableProperties;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import fr.frinn.custommachinery.common.guielement.EnergyGuiElement;
import fr.frinn.custommachinery.common.guielement.ProgressBarGuiElement;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.impl.guielement.AbstractGuiElement;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class EnergyGuiElementBuilder
implements IGuiElementBuilder<EnergyGuiElement> {
    @Override
    public GuiElementType<EnergyGuiElement> type() {
        return Registration.ENERGY_GUI_ELEMENT.get();
    }

    @Override
    public EnergyGuiElement make(AbstractGuiElement.Properties properties, @Nullable EnergyGuiElement from) {
        if (from != null) {
            return new EnergyGuiElement(properties, from.getEmptyTexture(), from.getFilledTexture(), from.getOrientation(), from.highlight());
        }
        return new EnergyGuiElement(properties, EnergyGuiElement.BASE_ENERGY_STORAGE_EMPTY_TEXTURE, EnergyGuiElement.BASE_ENERGY_STORAGE_FILLED_TEXTURE, ProgressBarGuiElement.Orientation.TOP, true);
    }

    @Override
    public PopupScreen makeConfigPopup(MachineEditScreen parent, MutableProperties properties, @Nullable EnergyGuiElement from, Consumer<EnergyGuiElement> onFinish) {
        return new EnergyGuiElementBuilderPopup((BaseScreen)parent, properties, from, onFinish);
    }

    public static class EnergyGuiElementBuilderPopup
    extends GuiElementBuilderPopup<EnergyGuiElement> {
        private ResourceLocation textureEmpty = EnergyGuiElement.BASE_ENERGY_STORAGE_EMPTY_TEXTURE;
        private ResourceLocation textureFilled = EnergyGuiElement.BASE_ENERGY_STORAGE_FILLED_TEXTURE;
        private CycleButton<ProgressBarGuiElement.Orientation> orientation;
        private Checkbox highlight;

        public EnergyGuiElementBuilderPopup(BaseScreen parent, MutableProperties properties, @Nullable EnergyGuiElement from, Consumer<EnergyGuiElement> onFinish) {
            super(parent, properties, from, onFinish);
            if (from != null) {
                this.textureEmpty = from.getEmptyTexture();
                this.textureFilled = from.getFilledTexture();
            }
        }

        @Override
        public EnergyGuiElement makeElement() {
            return new EnergyGuiElement(this.properties.build(), this.textureEmpty, this.textureFilled, (ProgressBarGuiElement.Orientation)((Object)this.orientation.getValue()), this.highlight.selected());
        }

        @Override
        public void addWidgets(GridLayout.RowHelper row) {
            this.addTexture(row, (Component)Component.translatable((String)"custommachinery.gui.creation.gui.empty"), texture -> {
                this.textureEmpty = texture;
            }, this.textureEmpty);
            this.addTexture(row, (Component)Component.translatable((String)"custommachinery.gui.creation.gui.filled"), texture -> {
                this.textureFilled = texture;
            }, this.textureFilled);
            this.addPriority(row);
            row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.gui.bar.orientation"), this.font));
            this.orientation = (CycleButton)row.addChild((LayoutElement)CycleButton.builder(orientation -> Component.literal((String)orientation.name())).withValues((Object[])ProgressBarGuiElement.Orientation.values()).withInitialValue((Object)(this.baseElement != null ? ((EnergyGuiElement)this.baseElement).getOrientation() : ProgressBarGuiElement.Orientation.TOP)).displayOnlyValue().create(0, 0, 100, 20, (Component)Component.translatable((String)"custommachinery.gui.creation.gui.bar.orientation")));
            row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.gui.highlight"), this.font));
            this.highlight = (Checkbox)row.addChild((LayoutElement)Checkbox.builder((Component)Component.translatable((String)"custommachinery.gui.creation.gui.highlight"), (Font)this.font).selected(this.baseElement == null || ((EnergyGuiElement)this.baseElement).highlight()).build());
        }
    }
}

