/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.tabs;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.client.screen.creation.gui.BackgroundEditorPopup;
import fr.frinn.custommachinery.client.screen.creation.gui.GridEditorPopup;
import fr.frinn.custommachinery.client.screen.creation.gui.GuiEditorWidget;
import fr.frinn.custommachinery.client.screen.creation.gui.GuiElementCreationPopup;
import fr.frinn.custommachinery.client.screen.creation.tabs.MachineEditTab;
import fr.frinn.custommachinery.common.guielement.BackgroundGuiElement;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.network.chat.Component;

public class GuiTab
extends MachineEditTab {
    public static final WidgetSprites CREATE_SPRITES = new WidgetSprites(CustomMachinery.rl("creation/create_button"), CustomMachinery.rl("creation/create_button_hovered"));
    public static final WidgetSprites BACKGROUND_SPRITES = new WidgetSprites(CustomMachinery.rl("creation/background_button"), CustomMachinery.rl("creation/background_button_hovered"));
    public static final WidgetSprites GRID_SPRITES = new WidgetSprites(CustomMachinery.rl("creation/grid_button"), CustomMachinery.rl("creation/grid_button_hovered"));
    private final GuiEditorWidget guiEditor;

    public GuiTab(MachineEditScreen parent) {
        super((Component)Component.translatable((String)"custommachinery.gui.creation.tab.gui"), parent);
        GridLayout.RowHelper row = this.layout.createRowHelper(1);
        row.defaultCellSetting().paddingTop(2);
        row.addChild((LayoutElement)new StringWidget(parent.width, 0, (Component)Component.empty(), Minecraft.getInstance().font));
        BackgroundGuiElement background = parent.getBuilder().getGuiElements().stream().filter(element -> element instanceof BackgroundGuiElement).map(element -> (BackgroundGuiElement)element).findFirst().orElse(null);
        this.guiEditor = background != null ? (GuiEditorWidget)row.addChild((LayoutElement)new GuiEditorWidget(parent, parent.x, parent.y, background.getWidth(), background.getHeight(), parent.getBuilder().getGuiElements()), row.newCellSettings().alignHorizontallyCenter()) : (GuiEditorWidget)row.addChild((LayoutElement)new GuiEditorWidget(parent, parent.x, parent.y, 256, 192, parent.getBuilder().getGuiElements()), row.newCellSettings().alignHorizontallyCenter());
    }

    public void setSize(int width, int height) {
        this.guiEditor.setSize(width, height);
        this.layout.arrangeElements();
    }

    @Override
    public List<AbstractWidget> getToolButtons() {
        ImageButton addButton = new ImageButton(0, 0, 20, 20, CREATE_SPRITES, button -> this.create());
        addButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.gui.add")));
        ImageButton backgroundButton = new ImageButton(0, 0, 20, 20, BACKGROUND_SPRITES, button -> this.background());
        backgroundButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.gui.background")));
        ImageButton gridButton = new ImageButton(0, 0, 20, 20, GRID_SPRITES, button -> this.grid());
        gridButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.gui.grid")));
        return List.of(addButton, backgroundButton, gridButton);
    }

    private void create() {
        this.parent.openPopup(new GuiElementCreationPopup(this.parent, this.guiEditor::addCreatedElement));
    }

    private void background() {
        this.parent.openPopup(new BackgroundEditorPopup(this.parent, this.guiEditor), "background");
    }

    private void grid() {
        this.parent.openPopup(new GridEditorPopup(this.parent, this.guiEditor), "grid");
    }
}

