/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.tabs;

import fr.frinn.custommachinery.client.ClientHandler;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.client.screen.creation.tabs.MachineEditTab;
import fr.frinn.custommachinery.common.guielement.SlotGuiElement;
import fr.frinn.custommachinery.common.init.CustomMachineItem;
import fr.frinn.custommachinery.impl.util.TextComponentUtils;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class TooltipsTab
extends MachineEditTab {
    public TooltipsTab(MachineEditScreen parent) {
        super((Component)Component.translatable((String)"custommachinery.gui.creation.tab.tooltips"), parent);
        GridLayout.RowHelper row = this.layout.createRowHelper(1);
        row.defaultCellSetting().paddingTop(5);
        row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.tooltips.title"), Minecraft.getInstance().font));
        MultiLineEditBox box = (MultiLineEditBox)row.addChild((LayoutElement)new MultiLineEditBox(Minecraft.getInstance().font, 0, 0, 200, 100, (Component)Component.empty(), (Component)Component.empty()));
        box.setValue(this.componentListToString(parent.getBuilder().getTooltips()));
        box.setValueListener(value -> {
            parent.getBuilder().setTooltips(this.stringToComponentList((String)value));
            parent.setChanged();
        });
        row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.tooltips.result"), Minecraft.getInstance().font));
        row.addChild((LayoutElement)new ItemSlotWidget());
    }

    private String componentListToString(List<Component> tooltips) {
        StringBuilder builder = new StringBuilder();
        Iterator<Component> iterator = tooltips.iterator();
        while (iterator.hasNext()) {
            builder.append(TextComponentUtils.getString(iterator.next()));
            if (!iterator.hasNext()) continue;
            builder.append("\n");
        }
        return builder.toString();
    }

    private List<Component> stringToComponentList(String s) {
        return Arrays.stream(s.split("\n")).filter(string -> !string.isEmpty()).map(Component::translatable).toList();
    }

    private class ItemSlotWidget
    extends AbstractWidget {
        public ItemSlotWidget() {
            super(0, 0, 18, 18, TooltipsTab.this.parent.getBuilder().getName());
        }

        protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            graphics.blit(SlotGuiElement.BASE_TEXTURE, this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            graphics.renderFakeItem(CustomMachineItem.makeMachineItem(TooltipsTab.this.parent.getBuilder().getLocation().getId()), this.getX() + 1, this.getY() + 1);
            if (mouseX >= this.getX() + 1 && mouseX <= this.getX() + 16 && mouseY >= this.getY() + 1 && mouseY <= this.getY() + 16) {
                ClientHandler.renderSlotHighlight(graphics, this.getX() + 1, this.getY() + 1, 16, 16);
                graphics.renderComponentTooltip(Minecraft.getInstance().font, this.getTooltips(), mouseX, mouseY);
            }
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }

        private List<Component> getTooltips() {
            return CustomMachineItem.makeMachineItem(TooltipsTab.this.parent.getBuilder().getLocation().getId()).getTooltipLines(Item.TooltipContext.of((Level)Minecraft.getInstance().level), (Player)Minecraft.getInstance().player, (TooltipFlag)new EditorTooltipFlag(TooltipsTab.this.parent.getBuilder().getTooltips()));
        }
    }

    public record EditorTooltipFlag(List<Component> tooltips) implements TooltipFlag
    {
        public boolean isAdvanced() {
            return true;
        }

        public boolean isCreative() {
            return true;
        }
    }
}

