/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.widget;

import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class IntegerSlider
extends AbstractSliderButton {
    private final Component baseMessage;
    private final int min;
    private final int max;
    private final boolean onlyValue;
    private final Consumer<Integer> responder;

    public static Builder builder() {
        return new Builder();
    }

    private IntegerSlider(int x, int y, int width, int height, Component message, double value, int min, int max, boolean onlyValue, Consumer<Integer> responder) {
        super(x, y, width, height, (Component)(onlyValue ? Component.literal((String)("" + (int)Mth.map((double)value, (double)0.0, (double)1.0, (double)min, (double)max))) : Component.empty().append(message).append(": " + (int)Mth.map((double)value, (double)0.0, (double)1.0, (double)min, (double)max))), value);
        this.baseMessage = message;
        this.min = min;
        this.max = max;
        this.onlyValue = onlyValue;
        this.responder = responder;
    }

    public int intValue() {
        return (int)Mth.map((double)this.value, (double)0.0, (double)1.0, (double)this.min, (double)this.max);
    }

    public void setValue(int value) {
        this.value = Mth.clamp((double)Mth.map((double)value, (double)this.min, (double)this.max, (double)0.0, (double)1.0), (double)0.0, (double)1.0);
        this.applyValue();
        this.updateMessage();
    }

    protected void updateMessage() {
        if (this.onlyValue) {
            this.setMessage((Component)Component.literal((String)("" + this.intValue())));
        } else {
            this.setMessage((Component)Component.empty().append(this.baseMessage).append(": " + this.intValue()));
        }
    }

    protected void applyValue() {
        this.responder.accept(this.intValue());
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        int value = this.intValue();
        boolean pressed = super.keyPressed(keyCode, scanCode, modifiers);
        int modifier = Screen.hasShiftDown() ? this.max / 10 : (Screen.hasControlDown() ? this.max / 20 : 1);
        switch (keyCode) {
            case 262: {
                this.setValue(value + modifier);
                break;
            }
            case 263: {
                this.setValue(value - modifier);
            }
        }
        return pressed;
    }

    public static class Builder {
        private int defaultValue = 0;
        private int min = 0;
        private int max = 1000;
        private boolean onlyValue = false;
        private Consumer<Integer> responder = value -> {};

        public Builder bounds(int min, int max) {
            this.min = min;
            this.max = max;
            this.defaultValue = Mth.clamp((int)this.defaultValue, (int)this.min, (int)this.max);
            return this;
        }

        public Builder defaultValue(int defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder displayOnlyValue() {
            this.onlyValue = true;
            return this;
        }

        public Builder setResponder(Consumer<Integer> responder) {
            this.responder = responder;
            return this;
        }

        public IntegerSlider create(int x, int y, int width, int height, Component message) {
            return new IntegerSlider(x, y, width, height, message, Mth.map((double)Mth.clamp((int)this.defaultValue, (int)this.min, (int)this.max), (double)this.min, (double)this.max, (double)0.0, (double)1.0), this.min, this.max, this.onlyValue, this.responder);
        }
    }
}

