/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.machine.CustomMachineJsonReloadListener;
import fr.frinn.custommachinery.common.network.SOpenCreationScreenPacket;
import fr.frinn.custommachinery.common.network.SOpenEditScreenPacket;
import fr.frinn.custommachinery.common.network.SOpenFilePacket;
import fr.frinn.custommachinery.common.util.CMVerifier;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.profiling.InactiveProfiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class CMCommand {
    public static final SuggestionProvider<CommandSourceStack> ALL_MACHINES = SuggestionProviders.register((ResourceLocation)CustomMachinery.rl("all_machines"), (commandContext, suggestionsBuilder) -> CMCommand.suggestCMResource(CMCommand.editableMachines(), suggestionsBuilder));

    public static LiteralArgumentBuilder<CommandSourceStack> register(String name) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)name).then(CMCommand.logging())).then(CMCommand.reload())).then(CMCommand.create())).then(CMCommand.edit())).then(CMCommand.verify());
    }

    private static ArgumentBuilder<CommandSourceStack, ?> logging() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"log").requires(cs -> cs.hasPermission(2))).executes(ctx -> {
            Entity patt0$temp = ((CommandSourceStack)ctx.getSource()).getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SOpenFilePacket(new File("logs/custommachinery.log").toURI().toString()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return 0;
        });
    }

    private static ArgumentBuilder<CommandSourceStack, ?> reload() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(cs -> cs.hasPermission(2))).executes(ctx -> {
            Entity patt0$temp = ((CommandSourceStack)ctx.getSource()).getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                CMCommand.reloadMachines(player.server, player);
            }
            return 0;
        });
    }

    private static ArgumentBuilder<CommandSourceStack, ?> create() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"create").requires(cs -> cs.hasPermission(2) && cs.isPlayer())).executes(ctx -> {
            Entity patt0$temp = ((CommandSourceStack)ctx.getSource()).getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SOpenCreationScreenPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return 0;
        });
    }

    private static ArgumentBuilder<CommandSourceStack, ?> edit() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"edit").requires(cs -> cs.hasPermission(2) && cs.isPlayer())).then(Commands.argument((String)"machine", (ArgumentType)ResourceLocationArgument.id()).suggests(ALL_MACHINES).executes(ctx -> {
            Entity patt0$temp = ((CommandSourceStack)ctx.getSource()).getEntity();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                ResourceLocation machine = ResourceLocationArgument.getId((CommandContext)ctx, (String)"machine");
                if (!CustomMachinery.MACHINES.containsKey(machine) || CustomMachinery.MACHINES.get(machine).isDummy()) {
                    player.sendSystemMessage((Component)Component.translatable((String)"custommachinery.command.edit.missing", (Object[])new Object[]{machine.toString()}).withStyle(ChatFormatting.GRAY));
                } else if (!CustomMachinery.MACHINES.get(machine).getLocation().canEdit()) {
                    player.sendSystemMessage((Component)Component.translatable((String)"custommachinery.command.edit.cant", (Object[])new Object[]{machine.toString()}).withStyle(ChatFormatting.GRAY));
                } else {
                    PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SOpenEditScreenPacket(machine), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            return 0;
        }));
    }

    public static void reloadMachines(MinecraftServer server, @Nullable ServerPlayer player) {
        new CustomMachineJsonReloadListener().reload(CompletableFuture::completedFuture, server.getResourceManager(), (ProfilerFiller)InactiveProfiler.INSTANCE, (ProfilerFiller)InactiveProfiler.INSTANCE, (Executor)server, (Executor)server).thenRun(() -> {
            if (player != null) {
                player.sendSystemMessage((Component)Component.translatable((String)"custommachinery.command.reload").withStyle(ChatFormatting.GRAY));
            }
        });
    }

    private static CompletableFuture<Suggestions> suggestCMResource(Iterable<ResourceLocation> resources, SuggestionsBuilder builder) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        boolean bl = string.indexOf(58) > -1;
        for (ResourceLocation object : resources) {
            if (bl) {
                String string2 = object.toString();
                if (!SharedSuggestionProvider.matchesSubStr((String)string, (String)string2)) continue;
                builder.suggest(object.toString());
                continue;
            }
            if (!SharedSuggestionProvider.matchesSubStr((String)string, (String)object.getNamespace()) && (!object.getNamespace().equals("custommachinery") || !SharedSuggestionProvider.matchesSubStr((String)string, (String)object.getPath()))) continue;
            builder.suggest(object.toString());
        }
        return builder.buildFuture();
    }

    private static List<ResourceLocation> editableMachines() {
        return CustomMachinery.MACHINES.entrySet().stream().filter(entry -> ((CustomMachine)entry.getValue()).getLocation().canEdit()).map(Map.Entry::getKey).toList();
    }

    private static ArgumentBuilder<CommandSourceStack, ?> verify() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"verify").requires(cs -> cs.hasPermission(2))).executes(ctx -> {
            int errors = CMVerifier.verify(((CommandSourceStack)ctx.getSource()).getLevel().getRecipeManager());
            if (errors > 0) {
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.translatable((String)"custommachinery.command.verify.error", (Object[])new Object[]{errors}).withStyle(ChatFormatting.RED).append(" ").append((Component)Component.translatable((String)"custommachinery.command.verify.log").withStyle(style -> style.withColor(ChatFormatting.GOLD).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/cm log")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"custommachinery.command.verify.log.tooltip"))))));
            } else {
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.translatable((String)"custommachinery.command.verify.success").withStyle(ChatFormatting.GREEN).append(" ").append((Component)Component.translatable((String)"custommachinery.command.verify.log").withStyle(style -> style.withColor(ChatFormatting.GOLD).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/cm log")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"custommachinery.command.verify.log.tooltip"))))));
            }
            return 0;
        });
    }
}

