/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.component;

import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.BlockStructure;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class StructureMachineComponent
extends AbstractMachineComponent {
    public StructureMachineComponent(IMachineComponentManager manager) {
        super(manager, ComponentIOMode.NONE);
    }

    public MachineComponentType<StructureMachineComponent> getType() {
        return Registration.STRUCTURE_MACHINE_COMPONENT.get();
    }

    public boolean checkStructure(BlockStructure pattern) {
        return pattern.match((LevelReader)this.getManager().getTile().getLevel(), this.getManager().getTile().getBlockPos(), (Direction)this.getManager().getTile().getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING));
    }

    public void destroyStructure(BlockStructure pattern, boolean drops) {
        pattern.getBlocks((Direction)this.getManager().getTile().getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).forEach((pos, ingredient) -> {
            if (!ingredient.test(PartialBlockState.MACHINE) && !ingredient.test(PartialBlockState.ANY)) {
                this.getManager().getLevel().destroyBlock(pos.offset((Vec3i)this.getManager().getTile().getBlockPos()), drops);
            }
        });
    }

    public void placeStructure(BlockStructure pattern, boolean drops) {
        pattern.getBlocks((Direction)this.getManager().getTile().getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).forEach((pos, ingredient) -> {
            BlockPos worldPos = pos.offset((Vec3i)this.getManager().getTile().getBlockPos());
            if (pos != BlockPos.ZERO && !ingredient.test(PartialBlockState.ANY)) {
                if (!this.getManager().getLevel().getBlockState(worldPos).isAir()) {
                    this.getManager().getLevel().destroyBlock(worldPos, drops);
                }
                this.setBlock(this.getManager().getLevel(), worldPos, (PartialBlockState)ingredient.getAll().get(0));
            }
        });
    }

    private void setBlock(Level world, BlockPos pos, PartialBlockState state) {
        world.setBlockAndUpdate(pos, state.getBlockState());
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile != null && state.getNbt() != null && !state.getNbt().isEmpty()) {
            CompoundTag nbt = state.getNbt().copy();
            nbt.putInt("x", pos.getX());
            nbt.putInt("y", pos.getY());
            nbt.putInt("z", pos.getZ());
            tile.loadWithComponents(nbt, (HolderLookup.Provider)world.registryAccess());
        }
    }
}

