/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.component.handler;

import com.google.common.collect.Maps;
import fr.frinn.custommachinery.api.component.IDumpComponent;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.ISerializableComponent;
import fr.frinn.custommachinery.api.component.ITickableComponent;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.network.ISyncable;
import fr.frinn.custommachinery.api.network.ISyncableStuff;
import fr.frinn.custommachinery.common.component.FluidMachineComponent;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.transfer.InteractionFluidHandler;
import fr.frinn.custommachinery.common.util.transfer.SidedFluidHandler;
import fr.frinn.custommachinery.impl.component.AbstractComponentHandler;
import fr.frinn.custommachinery.impl.component.config.IOSideMode;
import fr.frinn.custommachinery.impl.component.config.RelativeSide;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class FluidComponentHandler
extends AbstractComponentHandler<FluidMachineComponent>
implements ISerializableComponent,
ISyncableStuff,
ITickableComponent,
IDumpComponent,
IFluidHandler {
    public final InteractionFluidHandler interactionFluidHandler = new InteractionFluidHandler(this);
    private final Map<Direction, SidedFluidHandler> sidedHandlers = Maps.newEnumMap(Direction.class);
    private final Map<Direction, BlockCapabilityCache<IFluidHandler, Direction>> neighbourStorages = Maps.newEnumMap(Direction.class);
    private final List<FluidMachineComponent> inputs = new ArrayList<FluidMachineComponent>();
    private final List<FluidMachineComponent> outputs = new ArrayList<FluidMachineComponent>();

    public FluidComponentHandler(IMachineComponentManager manager, List<FluidMachineComponent> components) {
        super(manager, components);
        components.forEach(component -> {
            component.getConfig().setCallback(this::configChanged);
            if (component.getMode().isInput()) {
                this.inputs.add((FluidMachineComponent)component);
            }
            if (component.getMode().isOutput()) {
                this.outputs.add((FluidMachineComponent)component);
            }
        });
        for (Direction side : Direction.values()) {
            this.sidedHandlers.put(side, new SidedFluidHandler(side, this));
        }
    }

    public void configChanged(RelativeSide side, IOSideMode oldMode, IOSideMode newMode) {
        if (oldMode.isNone() != newMode.isNone()) {
            this.getManager().getTile().invalidateCapabilities();
        }
    }

    @Nullable
    public IFluidHandler getFluidHandler(@Nullable Direction side) {
        if (side == null) {
            return this;
        }
        if (this.getComponents().stream().anyMatch(component -> !((IOSideMode)component.getConfig().getDirectionMode(side)).isNone())) {
            return this.sidedHandlers.get(side);
        }
        return null;
    }

    public MachineComponentType<FluidMachineComponent> getType() {
        return Registration.FLUID_MACHINE_COMPONENT.get();
    }

    @Override
    public Optional<FluidMachineComponent> getComponentForID(String id) {
        return this.getComponents().stream().filter(component -> component.getId().equals(id)).findFirst();
    }

    @Override
    public void serverTick() {
        for (Direction side : Direction.values()) {
            IFluidHandler neighbour;
            if (this.getComponents().stream().noneMatch(component -> component.getConfig().canAutoIO(side))) continue;
            if (this.neighbourStorages.get(side) == null) {
                this.neighbourStorages.put(side, (BlockCapabilityCache<IFluidHandler, Direction>)BlockCapabilityCache.create((BlockCapability)Capabilities.FluidHandler.BLOCK, (ServerLevel)((ServerLevel)this.getManager().getLevel()), (BlockPos)this.getManager().getTile().getBlockPos().relative(side), (Object)side.getOpposite(), () -> !this.getManager().getTile().isRemoved(), () -> this.neighbourStorages.remove(side)));
            }
            if ((neighbour = (IFluidHandler)this.neighbourStorages.get(side).getCapability()) == null) continue;
            this.getComponents().forEach(component -> {
                if (component.getConfig().isAutoInput() && ((IOSideMode)component.getConfig().getDirectionMode(side)).isInput() && component.getFluid().getAmount() < component.getCapacity()) {
                    FluidUtil.tryFluidTransfer((IFluidHandler)this.sidedHandlers.get(side), (IFluidHandler)neighbour, (int)Integer.MAX_VALUE, (boolean)true);
                }
                if (component.getConfig().isAutoOutput() && ((IOSideMode)component.getConfig().getDirectionMode(side)).isOutput() && component.getFluid().getAmount() > 0) {
                    FluidUtil.tryFluidTransfer((IFluidHandler)neighbour, (IFluidHandler)this.sidedHandlers.get(side), (int)Integer.MAX_VALUE, (boolean)true);
                }
            });
        }
    }

    @Override
    public void serialize(CompoundTag nbt, HolderLookup.Provider registries) {
        ListTag componentsNBT = new ListTag();
        this.getComponents().forEach(component -> {
            CompoundTag componentNBT = new CompoundTag();
            component.serialize(componentNBT, registries);
            componentNBT.putString("id", component.getId());
            componentsNBT.add((Object)componentNBT);
        });
        nbt.put("fluids", (Tag)componentsNBT);
    }

    @Override
    public void deserialize(CompoundTag nbt, HolderLookup.Provider registries) {
        if (nbt.contains("fluids", 9)) {
            ListTag componentsNBT = nbt.getList("fluids", 10);
            componentsNBT.forEach(inbt -> {
                CompoundTag componentNBT;
                if (inbt instanceof CompoundTag && (componentNBT = (CompoundTag)inbt).contains("id", 8)) {
                    this.getComponents().stream().filter(component -> component.getId().equals(componentNBT.getString("id"))).findFirst().ifPresent(component -> component.deserialize(componentNBT, registries));
                }
            });
        }
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        this.getComponents().forEach(component -> component.getStuffToSync(container));
    }

    @Override
    public void dump(List<String> ids) {
        this.getComponents().stream().filter(component -> ids.contains(component.getId())).forEach(component -> component.setFluidStack(FluidStack.EMPTY));
    }

    public int getFluidAmount(String tank, FluidStack stack) {
        Predicate<FluidMachineComponent> tankPredicate = component -> tank.isEmpty() || component.getId().equals(tank);
        return this.inputs.stream().filter(component -> FluidStack.isSameFluidSameComponents((FluidStack)component.getFluid(), (FluidStack)stack) && tankPredicate.test((FluidMachineComponent)component)).mapToInt(component -> component.getFluid().getAmount()).sum();
    }

    public int getSpaceForFluid(String tank, FluidStack stack) {
        Predicate<FluidMachineComponent> tankPredicate = component -> tank.isEmpty() || component.getId().equals(tank);
        return this.outputs.stream().filter(component -> component.isFluidValid(0, stack) && tankPredicate.test((FluidMachineComponent)component)).mapToInt(FluidMachineComponent::getRecipeRemainingSpace).sum();
    }

    public void removeFromInputs(String tank, FluidStack stack) {
        AtomicLong toRemove = new AtomicLong(stack.getAmount());
        Predicate<FluidMachineComponent> tankPredicate = component -> tank.isEmpty() || component.getId().equals(tank);
        this.inputs.stream().filter(component -> component.getFluid().getFluid() == stack.getFluid() && tankPredicate.test((FluidMachineComponent)component)).forEach(component -> {
            long maxExtract = Math.min((long)component.getFluid().getAmount(), toRemove.get());
            toRemove.addAndGet(-maxExtract);
            component.recipeExtract(maxExtract);
        });
    }

    public void addToOutputs(String tank, FluidStack stack) {
        AtomicLong toAdd = new AtomicLong(stack.getAmount());
        Predicate<FluidMachineComponent> tankPredicate = component -> tank.isEmpty() || component.getId().equals(tank);
        this.outputs.stream().filter(component -> component.isFluidValid(0, stack) && tankPredicate.test((FluidMachineComponent)component)).sorted(Comparator.comparingInt(component -> FluidStack.isSameFluidSameComponents((FluidStack)component.getFluid(), (FluidStack)stack) ? -1 : 1)).forEach(component -> {
            long maxInsert = Math.min((long)component.getRecipeRemainingSpace(), toAdd.get());
            toAdd.addAndGet(-maxInsert);
            component.recipeInsert(stack.getFluid(), maxInsert, null);
        });
    }

    public int getTanks() {
        return this.getComponents().size();
    }

    public FluidStack getFluidInTank(int tank) {
        this.validateTankIndex(tank);
        return ((FluidMachineComponent)this.getComponents().get(tank)).getFluid();
    }

    public int getTankCapacity(int tank) {
        this.validateTankIndex(tank);
        return ((FluidMachineComponent)this.getComponents().get(tank)).getCapacity();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        this.validateTankIndex(tank);
        return ((FluidMachineComponent)this.getComponents().get(tank)).isFluidValid(0, stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack toFill = resource.copy();
        for (FluidMachineComponent component : this.getComponents()) {
            toFill.shrink(component.fill(toFill, action));
            if (!toFill.isEmpty()) continue;
            break;
        }
        return resource.getAmount() - toFill.getAmount();
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidMachineComponent component;
        int toDrain = 0;
        Iterator iterator = this.getComponents().iterator();
        while (iterator.hasNext() && (toDrain += (component = (FluidMachineComponent)iterator.next()).drain(resource.copyWithAmount(resource.getAmount() - toDrain), action).getAmount()) != resource.getAmount()) {
        }
        return resource.copyWithAmount(toDrain);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        for (FluidMachineComponent component : this.getComponents()) {
            FluidStack drained = component.drain(maxDrain, action);
            if (drained.isEmpty()) continue;
            return drained;
        }
        return FluidStack.EMPTY;
    }

    protected void validateTankIndex(int tank) {
        if (tank < 0 || tank >= this.getTanks()) {
            throw new RuntimeException("Tank " + tank + " not in valid range - [0," + this.getTanks() + ")");
        }
    }
}

