/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.component.item;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function8;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IComparatorInputComponent;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.component.ISerializableComponent;
import fr.frinn.custommachinery.api.component.ISideConfigComponent;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.network.ISyncable;
import fr.frinn.custommachinery.api.network.ISyncableStuff;
import fr.frinn.custommachinery.api.utils.Filter;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.network.syncable.IOSideConfigSyncable;
import fr.frinn.custommachinery.common.network.syncable.ItemStackSyncable;
import fr.frinn.custommachinery.common.util.slot.SlotItemComponent;
import fr.frinn.custommachinery.impl.codec.DefaultCodecs;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import fr.frinn.custommachinery.impl.component.config.IOSideConfig;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class ItemMachineComponent
extends AbstractMachineComponent
implements ISerializableComponent,
ISyncableStuff,
IComparatorInputComponent,
ISideConfigComponent,
IItemHandlerModifiable {
    private final String id;
    private final int capacity;
    private final int maxInput;
    private final int maxOutput;
    private final Filter<Item> filter;
    private ItemStack stack = ItemStack.EMPTY;
    private final IOSideConfig config;
    private boolean locked;
    private boolean bypassLimit = false;

    public ItemMachineComponent(IMachineComponentManager manager, ComponentIOMode mode, String id, int capacity, int maxInput, int maxOutput, Filter<Item> filter, IOSideConfig.Template configTemplate, boolean locked) {
        super(manager, mode);
        this.id = id;
        this.capacity = capacity;
        this.maxInput = maxInput;
        this.maxOutput = maxOutput;
        this.filter = filter;
        this.config = configTemplate.build(this);
        this.locked = locked;
    }

    public MachineComponentType<ItemMachineComponent> getType() {
        return Registration.ITEM_MACHINE_COMPONENT.get();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public IOSideConfig getConfig() {
        return this.config;
    }

    public ItemStack getItemStack() {
        return this.stack;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setItemStack(ItemStack stack) {
        this.stack = stack;
        this.getManager().markDirty();
        this.getManager().getTile().getUpgradeManager().markDirty();
    }

    public boolean canOutput() {
        return true;
    }

    public boolean shouldDrop() {
        return true;
    }

    public ItemStack insertItemBypassLimit(ItemStack stack, boolean simulate) {
        this.bypassLimit = true;
        ItemStack remainder = this.insertItem(0, stack, simulate);
        this.bypassLimit = false;
        return remainder;
    }

    public ItemStack extractItemBypassLimit(int amount, boolean simulate) {
        this.bypassLimit = true;
        ItemStack extracted = this.extractItem(0, amount, simulate);
        this.bypassLimit = false;
        return extracted;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public SlotItemComponent makeSlot(int index, int x, int y) {
        return new SlotItemComponent(this, index, x, y);
    }

    @Override
    public void serialize(CompoundTag nbt, HolderLookup.Provider registries) {
        if (!this.stack.isEmpty()) {
            nbt.put("item", this.stack.save(registries, (Tag)new CompoundTag()));
        }
        nbt.put("config", (Tag)this.config.serialize());
    }

    @Override
    public void deserialize(CompoundTag nbt, HolderLookup.Provider registries) {
        if (nbt.contains("item", 10)) {
            this.stack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)nbt.getCompound("item"));
        }
        if (nbt.contains("config")) {
            this.config.deserialize(nbt.getCompound("config"));
        }
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        container.accept(ItemStackSyncable.create(() -> this.stack, stack -> {
            this.stack = stack;
        }));
        container.accept(IOSideConfigSyncable.create(this::getConfig, this.config::set));
    }

    @Override
    public int getComparatorInput() {
        return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)new SimpleContainer(new ItemStack[]{this.stack}));
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.stack;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.stack = stack;
        this.getManager().markDirty();
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (slot != 0) {
            throw new IllegalArgumentException("Can't get capacity for slot " + slot + ", ItemMachineComponent only has slot 0");
        }
        if (stack.isEmpty() || !this.isItemValid(0, stack) || !this.stack.isEmpty() && !ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)stack)) {
            return stack;
        }
        int amountToInsert = stack.getCount();
        if (!this.bypassLimit) {
            amountToInsert = Math.min(amountToInsert, this.maxInput);
        }
        amountToInsert = Math.min(amountToInsert, stack.getMaxStackSize());
        if (!this.stack.isEmpty()) {
            amountToInsert = Math.min(amountToInsert, this.stack.getMaxStackSize() - this.stack.getCount());
        }
        if ((amountToInsert = Math.min(amountToInsert, this.capacity - this.stack.getCount())) <= 0) {
            return stack;
        }
        if (this.stack.isEmpty()) {
            if (!simulate) {
                this.stack = stack.copyWithCount(amountToInsert);
                this.getManager().markDirty();
            }
        } else if (!simulate) {
            this.stack.grow(amountToInsert);
            this.getManager().markDirty();
        }
        if (amountToInsert == stack.getCount()) {
            return ItemStack.EMPTY;
        }
        return stack.copyWithCount(stack.getCount() - amountToInsert);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot != 0) {
            throw new IllegalArgumentException("Can't get capacity for slot " + slot + ", ItemMachineComponent only has slot 0");
        }
        if (amount <= 0 || this.stack.isEmpty() || !this.canOutput()) {
            return ItemStack.EMPTY;
        }
        if (!this.bypassLimit) {
            amount = Math.min(amount, this.maxOutput);
        }
        amount = Math.min(amount, this.stack.getCount());
        ItemStack extracted = this.stack.copyWithCount(amount);
        if (!simulate) {
            this.stack.shrink(amount);
            this.getManager().markDirty();
        }
        return extracted;
    }

    public int getSlotLimit(int slot) {
        if (slot == 0) {
            return this.capacity;
        }
        throw new IllegalArgumentException("Can't get capacity for slot " + slot + ", ItemMachineComponent only has slot 0");
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.filter.test(stack.getItem());
    }

    public static class Template
    implements IMachineComponentTemplate<ItemMachineComponent> {
        public static final NamedCodec<Template> CODEC = Template.defaultCodec(Template::new, "Item machine component");
        public final String id;
        public final ComponentIOMode mode;
        public final int capacity;
        public final int maxInput;
        public final int maxOutput;
        public final Filter<Item> filter;
        public final IOSideConfig.Template config;
        public final boolean locked;

        public static <T extends Template> NamedCodec<T> defaultCodec(Function8<String, ComponentIOMode, Integer, Optional<Integer>, Optional<Integer>, Filter<Item>, Optional<IOSideConfig.Template>, Boolean, T> constructor, String name) {
            return NamedCodec.record(instance -> instance.group(NamedCodec.STRING.fieldOf("id").forGetter(template -> template.id), ComponentIOMode.CODEC.optionalFieldOf("mode", ComponentIOMode.BOTH).forGetter(template -> template.mode), NamedCodec.INT.optionalFieldOf("capacity", 64).forGetter(template -> template.capacity), NamedCodec.INT.optionalFieldOf("max_input").forGetter(template -> template.maxInput == template.capacity ? Optional.empty() : Optional.of(template.maxInput)), NamedCodec.INT.optionalFieldOf("max_output").forGetter(template -> template.maxOutput == template.capacity ? Optional.empty() : Optional.of(template.maxOutput)), Filter.codec(DefaultCodecs.registryValueOrTag(BuiltInRegistries.ITEM)).orElse(Filter.empty()).forGetter(template -> template.filter), IOSideConfig.Template.CODEC.optionalFieldOf("config").forGetter(template -> template.config == template.mode.getBaseConfig() ? Optional.empty() : Optional.of(template.config)), NamedCodec.BOOL.optionalFieldOf("locked", false).aliases("lock").forGetter(template -> template.locked)).apply((Applicative)instance, constructor), name);
        }

        public Template(String id, ComponentIOMode mode, int capacity, Optional<Integer> maxInput, Optional<Integer> maxOutput, Filter<Item> filter, Optional<IOSideConfig.Template> config, boolean locked) {
            this.id = id;
            this.mode = mode;
            this.capacity = capacity;
            this.maxInput = maxInput.orElse(capacity);
            this.maxOutput = maxOutput.orElse(capacity);
            this.filter = filter;
            this.config = config.orElse(mode.getBaseConfig());
            this.locked = locked;
        }

        public boolean isItemValid(IMachineComponentManager manager, ItemStack stack) {
            return true;
        }

        @Override
        public MachineComponentType<ItemMachineComponent> getType() {
            return Registration.ITEM_MACHINE_COMPONENT.get();
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public boolean canAccept(Object ingredient, boolean isInput, IMachineComponentManager manager) {
            if (this.mode != ComponentIOMode.BOTH && isInput != this.mode.isInput()) {
                return false;
            }
            if (ingredient instanceof ItemStack) {
                ItemStack stack = (ItemStack)ingredient;
                return this.filter.test(stack.getItem()) && this.isItemValid(manager, stack);
            }
            if (ingredient instanceof List) {
                List list = (List)ingredient;
                return list.stream().allMatch(object -> {
                    if (object instanceof ItemStack) {
                        ItemStack stack = (ItemStack)object;
                        return this.filter.test(stack.getItem()) && this.isItemValid(manager, stack);
                    }
                    return false;
                });
            }
            return false;
        }

        @Override
        public ItemMachineComponent build(IMachineComponentManager manager) {
            return new ItemMachineComponent(manager, this.mode, this.id, this.capacity, this.maxInput, this.maxOutput, this.filter, this.config, this.locked);
        }
    }
}

