/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.config;

import com.google.common.collect.Lists;
import fr.frinn.custommachinery.common.util.LoggingLevel;
import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class CMConfig {
    public static final CMConfig CONFIG;
    public static final ModConfigSpec CONFIG_SPEC;
    public final ModConfigSpec.ConfigValue<Boolean> logMissingOptional;
    public final ModConfigSpec.ConfigValue<Boolean> logFirstEitherError;
    public final ModConfigSpec.ConfigValue<LoggingLevel> debugLevel;
    public final ModConfigSpec.ConfigValue<Boolean> logLegacyFolderFiles;
    public final ModConfigSpec.ConfigValue<Integer> boxRenderTime;
    public final ModConfigSpec.ConfigValue<Integer> structureRenderTime;
    public final ModConfigSpec.ConfigValue<Integer> blockTagCycleTime;
    public final ModConfigSpec.ConfigValue<Integer> itemSlotCycleTime;
    public final ModConfigSpec.ConfigValue<List<String>> modelFolders;

    public CMConfig(ModConfigSpec.Builder builder) {
        builder.push("logs");
        this.logMissingOptional = builder.comment("If true, all missing optional properties and their default values will be logged when parsing custom machines jsons.").define("log_missing_optional", false);
        this.logFirstEitherError = builder.comment("When parsing custom machines json files, some properties can be read with 2 serializers. Set this to true to log when the first serializer throw an error, even if the second succeed.").define("log_first_either_error", false);
        this.debugLevel = builder.comment("Configure what logs will be printed in the custommachinery.log file. Only logs with level higher or equal than selected will be printed. FATAL > ERROR > WARN > INFO > DEBUG > ALL").defineEnum("debug_level", (Enum)LoggingLevel.INFO);
        this.logLegacyFolderFiles = builder.comment("Displays a warning if there are files in legacy data folders, such as 'machines' instead of 'machine'").define("log_legacy_folder_files", true);
        builder.pop();
        builder.push("rendering");
        this.boxRenderTime = builder.comment("The time in milliseconds the block requirement working box will be rendered around the machines when clicking on the icon in the jei recipe.").defineInRange("box_render_time", 10000, 1, Integer.MAX_VALUE);
        this.structureRenderTime = builder.comment("The time in milliseconds the structure requirement structure will render in world when clicking on the icon in the jei recipe.").defineInRange("structure_render_time", 10000, 1, Integer.MAX_VALUE);
        this.blockTagCycleTime = builder.comment("The time in milliseconds each blocks will be shown when using a block tag in a structure.").defineInRange("block_tag_cycle_time", 1000, 1, Integer.MAX_VALUE);
        this.itemSlotCycleTime = builder.comment("The time in milliseconds the ghost item will be shown in a slot when a tag or more than 1 item is specified.").defineInRange("item_slot_cycle_time", 1000, 1, Integer.MAX_VALUE);
        builder.pop();
        builder.push("misc");
        this.modelFolders = builder.comment("A list of folder names where CM will load models json. These folders must be under the 'assets/namespace/models' folder.").define("model_folders", (Object)Lists.newArrayList((Object[])new String[]{"machine", "machines"}));
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(CMConfig::new);
        CONFIG = (CMConfig)pair.getLeft();
        CONFIG_SPEC = (ModConfigSpec)pair.getRight();
    }
}

