/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.crafting.machine;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.crafting.IProcessor;
import fr.frinn.custommachinery.api.crafting.IProcessorTemplate;
import fr.frinn.custommachinery.api.crafting.ProcessorType;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.machine.MachineStatus;
import fr.frinn.custommachinery.api.machine.MachineTile;
import fr.frinn.custommachinery.api.network.ISyncable;
import fr.frinn.custommachinery.api.network.ISyncableStuff;
import fr.frinn.custommachinery.common.crafting.machine.CustomMachineRecipe;
import fr.frinn.custommachinery.common.crafting.machine.MachineProcessorCore;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.machine.MachineAppearance;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.RecipeHolder;

public class MachineProcessor
implements IProcessor,
ISyncableStuff {
    private final MachineTile tile;
    private boolean initialized = false;
    private final List<MachineProcessorCore> cores;

    public MachineProcessor(MachineTile tile, int amount, int recipeCheckCooldown) {
        this.tile = tile;
        ImmutableList.Builder cores = ImmutableList.builder();
        for (int i = 0; i < amount; ++i) {
            cores.add((Object)new MachineProcessorCore(this, tile, recipeCheckCooldown, i + 1));
        }
        this.cores = cores.build();
    }

    public List<MachineProcessorCore> getCores() {
        return this.cores;
    }

    @Override
    public void tick() {
        if (!this.initialized) {
            this.init();
        }
        this.cores.forEach(MachineProcessorCore::tick);
        if (this.tile.getStatus() == MachineStatus.RUNNING && this.cores.stream().noneMatch(core -> core.getCurrentRecipe() != null)) {
            this.tile.setStatus(MachineStatus.IDLE);
            this.tile.setCustomAppearance(null);
            this.tile.setCustomGuiElements(null);
        }
    }

    private void init() {
        this.initialized = true;
        this.cores.forEach(MachineProcessorCore::init);
    }

    public void setRunning() {
        this.tile.setStatus(MachineStatus.RUNNING);
        if (this.cores.size() == 1) {
            List<IGuiElement> customGuiElements;
            RecipeHolder<CustomMachineRecipe> currentRecipe = this.cores.getFirst().getCurrentRecipe();
            if (currentRecipe == null) {
                return;
            }
            MachineAppearance customAppearance = ((CustomMachineRecipe)currentRecipe.value()).getCustomAppearance(this.tile.getMachine().getAppearance(this.tile().getStatus()));
            if (customAppearance != null) {
                this.tile.setCustomAppearance(customAppearance);
            }
            if ((customGuiElements = ((CustomMachineRecipe)currentRecipe.value()).getCustomGuiElements(this.tile.getMachine().getGuiElements())) != null && !customGuiElements.isEmpty()) {
                this.tile.setCustomGuiElements(customGuiElements);
            }
        }
    }

    public void setError(Component message) {
        if (this.cores.stream().allMatch(core -> core.getError() != null || core.getCurrentRecipe() == null)) {
            this.tile.setStatus(MachineStatus.ERRORED, message);
        }
        if (this.cores.size() == 1) {
            this.tile.setCustomAppearance(null);
            this.tile.setCustomGuiElements(null);
        }
    }

    @Override
    public void reset() {
        this.cores.forEach(MachineProcessorCore::reset);
        this.tile.setStatus(MachineStatus.IDLE);
        this.tile.setCustomAppearance(null);
        this.tile.setCustomGuiElements(null);
    }

    @Override
    public MachineTile tile() {
        return this.tile;
    }

    public ProcessorType<MachineProcessor> getType() {
        return Registration.MACHINE_PROCESSOR.get();
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag nbt = new CompoundTag();
        nbt.putString("type", this.getType().getId().toString());
        ListTag cores = new ListTag();
        this.cores.forEach(core -> cores.add((Object)core.serialize()));
        nbt.put("cores", (Tag)cores);
        return nbt;
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        if (nbt.contains("type", 8) && !nbt.getString("type").equals(this.getType().getId().toString())) {
            return;
        }
        if (nbt.contains("cores", 9)) {
            ListTag cores = nbt.getList("cores", 10);
            if (this.cores.size() == cores.size()) {
                for (int i = 0; i < this.cores.size(); ++i) {
                    this.cores.get(i).deserialize(cores.getCompound(i));
                }
            }
        }
    }

    @Override
    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        this.cores.forEach(core -> core.getStuffToSync(container));
    }

    @Override
    public void setMachineInventoryChanged() {
        this.cores.forEach(MachineProcessorCore::setMachineInventoryChanged);
    }

    @Override
    public void setSearchImmediately() {
        this.cores.forEach(MachineProcessorCore::setSearchImmediately);
    }

    public record Template(int amount, int recipeCheckCooldown) implements IProcessorTemplate<MachineProcessor>
    {
        public static final NamedCodec<Template> CODEC = NamedCodec.record(templateInstance -> templateInstance.group(NamedCodec.intRange(1, Integer.MAX_VALUE).optionalFieldOf("amount", 1).forGetter(template -> template.amount), NamedCodec.intRange(1, Integer.MAX_VALUE).optionalFieldOf("cooldown", 20).forGetter(template -> template.recipeCheckCooldown)).apply((Applicative)templateInstance, Template::new), "Machine processor");
        public static final Template DEFAULT = new Template(1, 20);

        @Override
        public ProcessorType<MachineProcessor> getType() {
            return Registration.MACHINE_PROCESSOR.get();
        }

        @Override
        public MachineProcessor build(MachineTile tile) {
            return new MachineProcessor(tile, this.amount, this.recipeCheckCooldown);
        }
    }
}

