/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.guielement;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.guielement.GuiElementType;
import fr.frinn.custommachinery.api.machine.MachineTile;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.impl.guielement.AbstractGuiElement;
import fr.frinn.custommachinery.impl.guielement.AbstractTexturedGuiElement;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ExperienceGuiElement
extends AbstractTexturedGuiElement {
    public static final ResourceLocation BASE_TEXTURE = CustomMachinery.rl("textures/gui/base_xp.png");
    public static final ResourceLocation BASE_TEXTURE_HOVERED = CustomMachinery.rl("textures/gui/base_xp_hovered.png");
    private final DisplayMode displayMode;
    private final Mode mode;
    public static final NamedCodec<ExperienceGuiElement> CODEC = NamedCodec.record(experienceGuiElement -> experienceGuiElement.group(ExperienceGuiElement.makePropertiesCodec(BASE_TEXTURE, BASE_TEXTURE_HOVERED).forGetter(AbstractGuiElement::getProperties), NamedCodec.enumCodec(DisplayMode.class).optionalFieldOf("display", DisplayMode.LEVEL).forGetter(element -> element.displayMode), NamedCodec.enumCodec(Mode.class).fieldOf("mode").forGetter(element -> element.mode)).apply((Applicative)experienceGuiElement, ExperienceGuiElement::new), "Experience gui element");

    public ExperienceGuiElement(AbstractGuiElement.Properties properties, DisplayMode displayMode, Mode mode) {
        super(properties);
        this.displayMode = displayMode;
        this.mode = mode;
    }

    public GuiElementType<ExperienceGuiElement> getType() {
        return Registration.EXPERIENCE_GUI_ELEMENT.get();
    }

    @Override
    public void handleClick(byte button, MachineTile tile, AbstractContainerMenu container, ServerPlayer player) {
        super.handleClick(button, tile, container, player);
        tile.getComponentManager().getComponent(Registration.EXPERIENCE_MACHINE_COMPONENT.get()).ifPresent(component -> {
            switch (this.mode.ordinal()) {
                case 0: {
                    component.addLevelToPlayer(-1, (Player)player);
                    break;
                }
                case 1: {
                    component.addLevelToPlayer(-10, (Player)player);
                    break;
                }
                case 2: {
                    component.addAllLevelToPlayer(false, (Player)player);
                    break;
                }
                case 3: {
                    component.addLevelToPlayer(1, (Player)player);
                    break;
                }
                case 4: {
                    component.addLevelToPlayer(10, (Player)player);
                    break;
                }
                case 5: {
                    component.addAllLevelToPlayer(true, (Player)player);
                }
            }
        });
    }

    public DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public static enum DisplayMode {
        LITERAL,
        LEVEL,
        BOTH;


        public boolean isLiteral() {
            return this == LITERAL;
        }

        public boolean isLevel() {
            return this == LEVEL;
        }

        public boolean isBoth() {
            return this == BOTH;
        }

        public static DisplayMode of(String value) {
            if (value.equalsIgnoreCase("literal")) {
                return LITERAL;
            }
            if (value.equalsIgnoreCase("level")) {
                return LEVEL;
            }
            if (value.equalsIgnoreCase("both")) {
                return BOTH;
            }
            return null;
        }
    }

    public static enum Mode {
        INPUT_ONE,
        INPUT_TEN,
        INPUT_ALL,
        OUTPUT_ONE,
        OUTPUT_TEN,
        OUTPUT_ALL,
        DISPLAY,
        DISPLAY_BAR;


        public boolean isInputOne() {
            return this == INPUT_ONE;
        }

        public boolean isInputAll() {
            return this == INPUT_ALL;
        }

        public boolean isInput() {
            return this.isInputOne() || this.isInputAll();
        }

        public boolean isOutputAll() {
            return this == OUTPUT_ALL;
        }

        public boolean isOutputOne() {
            return this == OUTPUT_ONE;
        }

        public boolean isOutput() {
            return this.isOutputOne() || this.isOutputAll();
        }

        public boolean isDisplay() {
            return this == DISPLAY || this == DISPLAY_BAR;
        }

        public boolean isDisplayBar() {
            return this == DISPLAY_BAR;
        }

        public Component title() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Component.translatable((String)"custommachinery.gui.element.experience.input_one");
                case 1 -> Component.translatable((String)"custommachinery.gui.element.experience.input_ten");
                case 2 -> Component.translatable((String)"custommachinery.gui.element.experience.input_all");
                case 3 -> Component.translatable((String)"custommachinery.gui.element.experience.output_one");
                case 4 -> Component.translatable((String)"custommachinery.gui.element.experience.output_ten");
                case 5 -> Component.translatable((String)"custommachinery.gui.element.experience.output_all");
                case 6, 7 -> Component.empty();
            };
        }
    }
}

