/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.guielement;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.guielement.GuiElementType;
import fr.frinn.custommachinery.api.guielement.IComponentGuiElement;
import fr.frinn.custommachinery.api.machine.MachineTile;
import fr.frinn.custommachinery.common.component.FluidMachineComponent;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.impl.guielement.AbstractGuiElement;
import fr.frinn.custommachinery.impl.guielement.AbstractTexturedGuiElement;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;

public class FluidGuiElement
extends AbstractTexturedGuiElement
implements IComponentGuiElement<FluidMachineComponent> {
    public static final ResourceLocation BASE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"custommachinery", (String)"textures/gui/base_fluid_storage.png");
    public static final NamedCodec<FluidGuiElement> CODEC = NamedCodec.record(fluidGuiElement -> fluidGuiElement.group(FluidGuiElement.makePropertiesCodec(BASE_TEXTURE).forGetter(AbstractGuiElement::getProperties), NamedCodec.STRING.fieldOf("id").forGetter(AbstractGuiElement::getId), NamedCodec.BOOL.optionalFieldOf("highlight", true).forGetter(FluidGuiElement::highlight)).apply((Applicative)fluidGuiElement, FluidGuiElement::new), "Fluid gui element");
    private final boolean highlight;

    public FluidGuiElement(AbstractGuiElement.Properties properties, String id, boolean highlight) {
        super(properties);
        this.highlight = highlight;
    }

    public boolean highlight() {
        return this.highlight;
    }

    public GuiElementType<FluidGuiElement> getType() {
        return Registration.FLUID_GUI_ELEMENT.get();
    }

    @Override
    public MachineComponentType<FluidMachineComponent> getComponentType() {
        return Registration.FLUID_MACHINE_COMPONENT.get();
    }

    @Override
    public String getComponentId() {
        return this.getId();
    }

    @Override
    public void handleClick(byte button, MachineTile tile, AbstractContainerMenu container, ServerPlayer player) {
        ItemStack carried = container.getCarried();
        IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)carried.getCapability(Capabilities.FluidHandler.ITEM);
        if (carried.isEmpty() || fluidHandlerItem == null) {
            return;
        }
        int testDrainAmount = carried.is(Tags.Items.BUCKETS) ? 1000 : 1;
        tile.getComponentManager().getComponentHandler(Registration.FLUID_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(this.getId())).ifPresent(component -> {
            FluidActionResult result = FluidActionResult.FAILURE;
            if (component.getMode().isInput() && component.getCapacity() - component.getFluid().getAmount() > 0 && !fluidHandlerItem.drain(testDrainAmount, IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
                result = FluidUtil.tryEmptyContainerAndStow((ItemStack)carried, (IFluidHandler)component, (IItemHandler)new PlayerMainInvWrapper(player.getInventory()), (int)Integer.MAX_VALUE, (Player)player, (boolean)true);
            } else if (!component.getFluid().isEmpty()) {
                result = FluidUtil.tryFillContainerAndStow((ItemStack)carried, (IFluidHandler)component, (IItemHandler)new PlayerMainInvWrapper(player.getInventory()), (int)Integer.MAX_VALUE, (Player)player, (boolean)true);
            }
            ItemStack stack = result.getResult();
            if (result.isSuccess() && !player.isCreative()) {
                container.setCarried(stack);
            }
        });
    }
}

