/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.init;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.JsonOps;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.common.init.CustomMachineBlock;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import fr.frinn.custommachinery.impl.codec.DefaultCodecs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class StructureCreatorItem
extends Item {
    private static final NamedCodec<List<List<String>>> PATTERN_CODEC = NamedCodec.STRING.listOf().listOf();
    private static final NamedCodec<Map<Character, PartialBlockState>> KEYS_CODEC = NamedCodec.unboundedMap(DefaultCodecs.CHARACTER, PartialBlockState.CODEC, "Map<Character, Block>");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public StructureCreatorItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getPlayer() == null) {
            return InteractionResult.FAIL;
        }
        BlockPos pos = context.getClickedPos();
        BlockState state = context.getLevel().getBlockState(pos);
        ItemStack stack = context.getItemInHand();
        if (state.getBlock() instanceof CustomMachineBlock) {
            if (!context.getLevel().isClientSide()) {
                this.finishStructure(stack, pos, (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING), (ServerPlayer)context.getPlayer());
            }
            return InteractionResult.SUCCESS;
        }
        if (!StructureCreatorItem.getSelectedBlocks(stack).contains(pos)) {
            StructureCreatorItem.addSelectedBlock(stack, pos);
            return InteractionResult.SUCCESS;
        }
        if (StructureCreatorItem.getSelectedBlocks(stack).contains(pos)) {
            StructureCreatorItem.removeSelectedBlock(stack, pos);
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        int amount = StructureCreatorItem.getSelectedBlocks(stack).size();
        if (amount <= 0) {
            tooltip.add((Component)Component.translatable((String)"custommachinery.structure_creator.no_blocks").withStyle(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.translatable((String)"custommachinery.structure_creator.amount", (Object[])new Object[]{StructureCreatorItem.getSelectedBlocks(stack).size()}).withStyle(ChatFormatting.BLUE));
        }
        tooltip.add((Component)Component.translatable((String)"custommachinery.structure_creator.select").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"custommachinery.structure_creator.reset").withStyle(ChatFormatting.GOLD));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (player.isCrouching() && player.getItemInHand(hand).getItem() == this) {
            ItemStack stack = player.getItemInHand(hand);
            stack.remove(Registration.STRUCTURE_CREATOR_DATA);
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(level, player, hand);
    }

    public static List<BlockPos> getSelectedBlocks(ItemStack stack) {
        return Optional.ofNullable((List)stack.get(Registration.STRUCTURE_CREATOR_DATA)).orElse(new ArrayList());
    }

    public static void addSelectedBlock(ItemStack stack, BlockPos pos) {
        stack.update(Registration.STRUCTURE_CREATOR_DATA, new ArrayList(), list -> {
            list.add(pos);
            return list;
        });
    }

    public static void removeSelectedBlock(ItemStack stack, BlockPos pos) {
        stack.update(Registration.STRUCTURE_CREATOR_DATA, new ArrayList(), list -> {
            list.remove(pos);
            return list;
        });
    }

    private void finishStructure(ItemStack stack, BlockPos machinePos, Direction machineFacing, ServerPlayer player) {
        List<BlockPos> blocks = StructureCreatorItem.getSelectedBlocks(stack);
        blocks.add(machinePos);
        if (blocks.size() <= 1) {
            player.sendSystemMessage((Component)Component.translatable((String)"custommachinery.structure_creator.no_blocks"));
            return;
        }
        Level world = player.level();
        PartialBlockState[][][] states = this.getStructureArray(blocks, machineFacing, world);
        HashBiMap keys = HashBiMap.create();
        AtomicInteger charIndex = new AtomicInteger(97);
        Arrays.stream(states).flatMap(Arrays::stream).flatMap(Arrays::stream).filter(state -> !(state.getBlockState().getBlock() instanceof CustomMachineBlock) && state != PartialBlockState.ANY).distinct().forEach(state -> {
            if (charIndex.get() == 109) {
                charIndex.incrementAndGet();
            }
            keys.put((Object)Character.valueOf((char)charIndex.getAndIncrement()), state);
            if (charIndex.get() == 122) {
                charIndex.set(65);
            }
        });
        ArrayList pattern = new ArrayList();
        for (int i = 0; i < states.length; ++i) {
            ArrayList<String> floor = new ArrayList<String>();
            for (int j = 0; j < states[i].length; ++j) {
                StringBuilder row = new StringBuilder();
                for (int k = 0; k < states[i][j].length; ++k) {
                    PartialBlockState partial = states[i][j][k];
                    int key = partial.getBlockState().getBlock() instanceof CustomMachineBlock ? 109 : (partial == PartialBlockState.ANY ? 32 : (keys.containsValue((Object)partial) ? (int)((Character)keys.inverse().get((Object)partial)).charValue() : 63));
                    row.append((char)key);
                }
                floor.add(row.toString());
            }
            pattern.add(floor);
        }
        JsonElement keysJson = (JsonElement)KEYS_CODEC.encodeStart(JsonOps.INSTANCE, (Map<Character, PartialBlockState>)keys).result().orElseThrow(IllegalStateException::new);
        JsonElement patternJson = (JsonElement)PATTERN_CODEC.encodeStart(JsonOps.INSTANCE, pattern).result().orElseThrow(IllegalStateException::new);
        JsonObject both = new JsonObject();
        both.add("keys", keysJson);
        both.add("pattern", patternJson);
        String ctKubeString = ".requireStructure(" + patternJson.toString() + ", " + keysJson.toString() + ")";
        MutableComponent jsonText = Component.literal((String)"[JSON]").withStyle(style -> style.applyFormats(new ChatFormatting[]{ChatFormatting.YELLOW}).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)both.toString()))).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, both.toString())));
        MutableComponent prettyJsonText = Component.literal((String)"[PRETTY JSON]").withStyle(style -> style.applyFormats(new ChatFormatting[]{ChatFormatting.GOLD}).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)GSON.toJson((JsonElement)both)))).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, GSON.toJson((JsonElement)both))));
        MutableComponent crafttweakerText = Component.literal((String)"[CRAFTTWEAKER]").withStyle(style -> style.applyFormats(new ChatFormatting[]{ChatFormatting.AQUA}).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)ctKubeString))).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, ctKubeString)));
        MutableComponent kubeJSText = Component.literal((String)"[KUBEJS]").withStyle(style -> style.applyFormats(new ChatFormatting[]{ChatFormatting.DARK_PURPLE}).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)ctKubeString))).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, ctKubeString)));
        MutableComponent message = Component.translatable((String)"custommachinery.structure_creator.message", (Object[])new Object[]{jsonText, prettyJsonText, crafttweakerText, kubeJSText});
        player.sendSystemMessage((Component)message);
    }

    private PartialBlockState[][][] getStructureArray(List<BlockPos> blocks, Direction machineFacing, Level world) {
        int minX = blocks.stream().mapToInt(Vec3i::getX).min().orElseThrow(IllegalStateException::new);
        int maxX = blocks.stream().mapToInt(Vec3i::getX).max().orElseThrow(IllegalStateException::new);
        int minY = blocks.stream().mapToInt(Vec3i::getY).min().orElseThrow(IllegalStateException::new);
        int maxY = blocks.stream().mapToInt(Vec3i::getY).max().orElseThrow(IllegalStateException::new);
        int minZ = blocks.stream().mapToInt(Vec3i::getZ).min().orElseThrow(IllegalStateException::new);
        int maxZ = blocks.stream().mapToInt(Vec3i::getZ).max().orElseThrow(IllegalStateException::new);
        PartialBlockState[][][] states = machineFacing.getAxis() == Direction.Axis.X ? new PartialBlockState[maxY - minY + 1][maxX - minX + 1][maxZ - minZ + 1] : new PartialBlockState[maxY - minY + 1][maxZ - minZ + 1][maxX - minX + 1];
        AABB box = new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
        HashMap cache = new HashMap();
        BlockPos.betweenClosedStream((AABB)box).forEach(p -> {
            PartialBlockState partial;
            BlockState state = world.getBlockState(p);
            if (!blocks.contains(p)) {
                partial = PartialBlockState.ANY;
            } else if (cache.containsKey(state)) {
                partial = (PartialBlockState)cache.get(state);
            } else {
                partial = new PartialBlockState(state, Lists.newArrayList((Iterable)state.getProperties()), Optional.ofNullable(world.getBlockEntity(p)).map(be -> be.saveWithFullMetadata((HolderLookup.Provider)world.registryAccess())).orElse(null));
                cache.put(state, partial);
            }
            switch (machineFacing) {
                case EAST: {
                    states[p.getY() - minY][p.getX() - minX][maxZ - p.getZ()] = partial;
                    break;
                }
                case WEST: {
                    states[p.getY() - minY][maxX - p.getX()][p.getZ() - minZ] = partial;
                    break;
                }
                case SOUTH: {
                    states[p.getY() - minY][p.getZ() - minZ][p.getX() - minX] = partial;
                    break;
                }
                case NORTH: {
                    states[p.getY() - minY][maxZ - p.getZ()][maxX - p.getX()] = partial;
                }
            }
        });
        return states;
    }
}

