/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.kubejs;

import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import dev.latvian.mods.kubejs.error.KubeRuntimeException;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.script.ScriptType;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.crafting.IRecipeBuilder;
import fr.frinn.custommachinery.api.integration.jei.DisplayInfoTemplate;
import fr.frinn.custommachinery.api.integration.kubejs.RecipeJSBuilder;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.api.requirement.RecipeRequirement;
import fr.frinn.custommachinery.common.integration.kubejs.CustomMachineryRecipeSchemas;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import org.slf4j.helpers.MessageFormatter;

public abstract class AbstractRecipeJSBuilder<B extends IRecipeBuilder<? extends Recipe<?>>>
extends KubeRecipe
implements RecipeJSBuilder {
    public static final Map<ResourceLocation, Map<ResourceLocation, Integer>> IDS = new HashMap<ResourceLocation, Map<ResourceLocation, Integer>>();
    private final ResourceLocation typeID;
    private final NamedCodec<B> codec;
    private RecipeRequirement<?, ?> lastRequirement;
    private boolean jei = false;

    public AbstractRecipeJSBuilder(ResourceLocation typeID, NamedCodec<B> codec) {
        this.typeID = typeID;
        this.codec = codec;
    }

    public void afterLoaded() {
        super.afterLoaded();
        ResourceLocation machine = (ResourceLocation)this.getValue(CustomMachineryRecipeSchemas.MACHINE_ID);
        if (this.newRecipe) {
            int uniqueID = IDS.computeIfAbsent(this.typeID, id -> new HashMap()).computeIfAbsent(machine, m -> 0);
            IDS.get(this.typeID).put(machine, uniqueID + 1);
            this.id = ResourceLocation.fromNamespaceAndPath((String)"kubejs", (String)(this.typeID.getPath() + "/" + machine.getNamespace() + "/" + machine.getPath() + "/" + uniqueID));
        }
    }

    public KubeRecipe serializeChanges() {
        if (!this.newRecipe) {
            return super.serializeChanges();
        }
        B builder = this.makeBuilder();
        for (RecipeRequirement requirement : (List)this.getValue(CustomMachineryRecipeSchemas.REQUIREMENTS)) {
            builder.withRequirement(requirement);
        }
        for (RecipeRequirement requirement : (List)this.getValue(CustomMachineryRecipeSchemas.JEI_REQUIREMENTS)) {
            builder.withJeiRequirement(requirement);
        }
        builder.withPriority((Integer)this.getValue(CustomMachineryRecipeSchemas.PRIORITY));
        builder.withJeiPriority((Integer)this.getValue(CustomMachineryRecipeSchemas.JEI_PRIORITY));
        if (((Boolean)this.getValue(CustomMachineryRecipeSchemas.HIDDEN)).booleanValue()) {
            builder.hide();
        }
        this.id = this.getOrCreateId();
        DataResult result = this.codec.encodeStart(this.type.event.registries.json(), builder);
        if (result.result().isPresent()) {
            this.json = (JsonObject)result.result().get();
        } else if (result.error().isPresent()) {
            ConsoleJS.SERVER.error((Object)("Error in Custom Machine recipe: " + String.valueOf(this.id) + "\n" + ((DataResult.Error)result.error().get()).message()));
            this.json = new JsonObject();
        }
        if (this.json != null) {
            this.json.addProperty("type", this.typeID.toString());
        }
        return this;
    }

    public abstract B makeBuilder();

    public AbstractRecipeJSBuilder<B> jei() {
        this.jei = true;
        return this;
    }

    public AbstractRecipeJSBuilder<B> priority(int priority) {
        if (!this.jei) {
            this.setValue(CustomMachineryRecipeSchemas.PRIORITY, priority);
        } else {
            this.setValue(CustomMachineryRecipeSchemas.JEI_PRIORITY, priority);
        }
        return this;
    }

    public AbstractRecipeJSBuilder<B> chance(double chance) {
        if (this.lastRequirement != null) {
            this.lastRequirement.setChance(chance);
        } else {
            ScriptType.SERVER.console.warn((Object)"Can't set chance before adding requirements");
        }
        return this;
    }

    public AbstractRecipeJSBuilder<B> info(Consumer<DisplayInfoTemplate> consumer) {
        if (this.lastRequirement == null) {
            this.error("Can't add info on a null requirement !", new Object[0]);
        }
        try {
            DisplayInfoTemplate template = new DisplayInfoTemplate();
            consumer.accept(template);
            this.lastRequirement.info = template;
        }
        catch (Exception e) {
            this.error("Error when adding custom display info on requirement {}\n{}", this.lastRequirement, e);
        }
        return this;
    }

    public AbstractRecipeJSBuilder<B> hide() {
        this.setValue(CustomMachineryRecipeSchemas.HIDDEN, true);
        return this;
    }

    @Override
    public AbstractRecipeJSBuilder<B> delay(double delay) {
        if (this.lastRequirement != null) {
            this.lastRequirement.setDelay(delay);
        } else {
            ScriptType.SERVER.console.warn((Object)("Can't set delay for requirement: " + String.valueOf(this.lastRequirement)));
        }
        return this;
    }

    @Override
    public AbstractRecipeJSBuilder<B> addRequirement(IRequirement<?> requirement) {
        this.lastRequirement = new RecipeRequirement(requirement);
        if (!this.jei) {
            this.setValue(CustomMachineryRecipeSchemas.REQUIREMENTS, this.addToList(CustomMachineryRecipeSchemas.REQUIREMENTS, this.lastRequirement));
        } else {
            this.setValue(CustomMachineryRecipeSchemas.JEI_REQUIREMENTS, this.addToList(CustomMachineryRecipeSchemas.JEI_REQUIREMENTS, this.lastRequirement));
        }
        return this;
    }

    @Override
    public RecipeJSBuilder error(String error, Object ... args) {
        throw new KubeRuntimeException(MessageFormatter.arrayFormat((String)error, (Object[])args).getMessage());
    }

    protected <E> List<E> addToList(RecipeKey<List<E>> key, E element) {
        ArrayList<E> list = new ArrayList<E>((Collection)this.getValue(key));
        list.add(element);
        return list;
    }
}

