/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.kubejs;

import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.BooleanComponent;
import dev.latvian.mods.kubejs.recipe.component.ComponentRole;
import dev.latvian.mods.kubejs.recipe.component.ItemStackComponent;
import dev.latvian.mods.kubejs.recipe.component.NumberComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.TimeComponent;
import dev.latvian.mods.kubejs.recipe.schema.KubeRecipeFactory;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.kubejs.util.TickDuration;
import dev.latvian.mods.rhino.type.TypeInfo;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.requirement.RecipeRequirement;
import fr.frinn.custommachinery.common.integration.kubejs.CustomCraftRecipeBuilderJS;
import fr.frinn.custommachinery.common.integration.kubejs.CustomMachineRecipeBuilderJS;
import fr.frinn.custommachinery.common.machine.MachineAppearance;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public interface CustomMachineryRecipeSchemas {
    public static final RecipeComponent<ResourceLocation> RESOURCE_LOCATION = new RecipeComponent<ResourceLocation>(){

        public Codec<ResourceLocation> codec() {
            return ResourceLocation.CODEC;
        }

        public TypeInfo typeInfo() {
            return TypeInfo.of(ResourceLocation.class);
        }
    };
    public static final RecipeComponent<RecipeRequirement<?, ?>> REQUIREMENT_COMPONENT = new RecipeComponent<RecipeRequirement<?, ?>>(){

        public Codec<RecipeRequirement<?, ?>> codec() {
            return RecipeRequirement.CODEC.codec();
        }

        public TypeInfo typeInfo() {
            return TypeInfo.of(RecipeRequirement.class);
        }
    };
    public static final RecipeComponent<List<RecipeRequirement<?, ?>>> REQUIREMENT_LIST = REQUIREMENT_COMPONENT.asList();
    public static final RecipeComponent<MachineAppearance> CUSTOM_APPEARANCE = new RecipeComponent<MachineAppearance>(){

        public Codec<MachineAppearance> codec() {
            return MachineAppearance.CODEC.xmap(MachineAppearance::new, MachineAppearance::getProperties, "Machine appearance").codec();
        }

        public TypeInfo typeInfo() {
            return TypeInfo.of(MachineAppearance.class);
        }
    };
    public static final RecipeComponent<IGuiElement> CUSTOM_GUI_ELEMENTS = new RecipeComponent<IGuiElement>(){

        public Codec<IGuiElement> codec() {
            return IGuiElement.CODEC.codec();
        }

        public TypeInfo typeInfo() {
            return TypeInfo.of(IGuiElement.class);
        }
    };
    public static final RecipeKey<ResourceLocation> MACHINE_ID = RESOURCE_LOCATION.key("machine", ComponentRole.OTHER);
    public static final RecipeKey<TickDuration> TIME = TimeComponent.TICKS.key("time", ComponentRole.OTHER);
    public static final RecipeKey<ItemStack> OUTPUT = ItemStackComponent.ITEM_STACK.key("output", ComponentRole.OUTPUT);
    public static final RecipeKey<List<RecipeRequirement<?, ?>>> REQUIREMENTS = REQUIREMENT_LIST.key("requirements", ComponentRole.OTHER).optional(Collections.emptyList()).alwaysWrite().allowEmpty().exclude();
    public static final RecipeKey<List<RecipeRequirement<?, ?>>> JEI_REQUIREMENTS = REQUIREMENT_LIST.key("jei", ComponentRole.OTHER).optional(Collections.emptyList()).alwaysWrite().allowEmpty().exclude();
    public static final RecipeKey<Integer> PRIORITY = NumberComponent.INT.key("priority", ComponentRole.OTHER).optional((Object)0).alwaysWrite().exclude();
    public static final RecipeKey<Integer> JEI_PRIORITY = NumberComponent.INT.key("jeiPriority", ComponentRole.OTHER).optional((Object)0).alwaysWrite().exclude();
    public static final RecipeKey<Boolean> ERROR = BooleanComponent.BOOLEAN.key("error", ComponentRole.OTHER).optional((Object)false).alwaysWrite().exclude();
    public static final RecipeKey<Boolean> HIDDEN = BooleanComponent.BOOLEAN.key("hidden", ComponentRole.OTHER).optional((Object)false).alwaysWrite().exclude();
    public static final RecipeKey<MachineAppearance> APPEARANCE = CUSTOM_APPEARANCE.key("appearance", ComponentRole.OTHER).optional((Object)null).alwaysWrite().exclude();
    public static final RecipeKey<List<IGuiElement>> GUI = CUSTOM_GUI_ELEMENTS.asList().key("gui", ComponentRole.OTHER).optional(Collections.emptyList()).alwaysWrite().allowEmpty().exclude();
    public static final RecipeKey<List<Integer>> ALLOWED_CORES = NumberComponent.intRange((int)1, (int)Integer.MAX_VALUE).asList().key("cores", ComponentRole.OTHER).optional(Collections.emptyList()).alwaysWrite().allowEmpty().exclude();
    public static final RecipeKey<Boolean> SINGLE_CORE = BooleanComponent.BOOLEAN.key("single_core", ComponentRole.OTHER).optional((Object)false).alwaysWrite().exclude();
    public static final RecipeSchema CUSTOM_MACHINE = new RecipeSchema(new RecipeKey[]{MACHINE_ID, TIME, REQUIREMENTS, JEI_REQUIREMENTS, PRIORITY, JEI_PRIORITY, ERROR, HIDDEN, APPEARANCE, GUI, ALLOWED_CORES, SINGLE_CORE}).factory(new KubeRecipeFactory(CustomMachinery.rl("custom_machine"), TypeInfo.of(CustomMachineRecipeBuilderJS.class), CustomMachineRecipeBuilderJS::new));
    public static final RecipeSchema CUSTOM_CRAFT = new RecipeSchema(new RecipeKey[]{MACHINE_ID, OUTPUT, REQUIREMENTS, JEI_REQUIREMENTS, PRIORITY, JEI_PRIORITY, HIDDEN}).factory(new KubeRecipeFactory(CustomMachinery.rl("custom_craft"), TypeInfo.of(CustomCraftRecipeBuilderJS.class), CustomCraftRecipeBuilderJS::new));
}

