/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.kubejs.function;

import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.rhino.Wrapper;
import fr.frinn.custommachinery.common.component.ChunkloadMachineComponent;
import fr.frinn.custommachinery.common.component.EnergyMachineComponent;
import fr.frinn.custommachinery.common.component.FluidMachineComponent;
import fr.frinn.custommachinery.common.component.handler.FluidComponentHandler;
import fr.frinn.custommachinery.common.component.item.ItemMachineComponent;
import fr.frinn.custommachinery.common.init.CustomMachineTile;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.TaskDelayer;
import fr.frinn.custommachinery.impl.component.config.SideConfig;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class MachineJS {
    private final CustomMachineTile internal;
    private final CompoundTag nbt;

    protected MachineJS(CustomMachineTile internal) {
        this.internal = internal;
        this.nbt = this.internal.getComponentManager().getComponent(Registration.DATA_MACHINE_COMPONENT.get()).orElseThrow().getData();
    }

    public static MachineJS of(Object o) {
        BlockEntity blockEntity;
        if (o instanceof Wrapper) {
            Wrapper w = (Wrapper)o;
            o = w.unwrap();
        }
        if (o instanceof BlockEntity && (blockEntity = (BlockEntity)o) instanceof CustomMachineTile) {
            CustomMachineTile customMachineTile = (CustomMachineTile)blockEntity;
            return new MachineJS(customMachineTile);
        }
        if (o instanceof BlockContainerJS) {
            BlockContainerJS blockContainerJS = (BlockContainerJS)o;
            return MachineJS.of(blockContainerJS.getEntity());
        }
        return null;
    }

    public String getId() {
        return this.internal.getId().toString();
    }

    public void setId(String id) {
        ResourceLocation loc = ResourceLocation.tryParse((String)id);
        if (loc == null) {
            throw new IllegalArgumentException("Invalid machine ID: " + id);
        }
        TaskDelayer.enqueue(0, () -> {
            this.internal.resetProcess();
            this.internal.refreshMachine(loc);
        });
    }

    @Nullable
    public CompoundTag getData() {
        return this.nbt;
    }

    public boolean getPaused() {
        return this.internal.isPaused();
    }

    public void setPaused(boolean paused) {
        this.internal.setPaused(paused);
    }

    public SideConfig<?> getComponentConfig(String type) {
        return this.getComponentConfig(type, "");
    }

    public SideConfig<?> getComponentConfig(String type, String id) {
        return this.internal.getComponentManager().getConfigComponentById(type + ":" + id).orElseThrow(() -> new IllegalArgumentException("IO config not found for component with type: " + type + " and id: " + id)).getConfig();
    }

    @Nullable
    public Component getOwnerName() {
        return this.internal.getOwnerName();
    }

    @Nullable
    public UUID getOwnerId() {
        return this.internal.getOwnerId();
    }

    public boolean isOwner(LivingEntity entity) {
        return this.internal.isOwner(entity);
    }

    @Nullable
    public LivingEntity getOwner() {
        return this.internal.getOwner();
    }

    public void setOwner(LivingEntity entity) {
        this.internal.setOwner(entity);
    }

    public long getEnergyStored() {
        return this.internal.getComponentManager().getComponent(Registration.ENERGY_MACHINE_COMPONENT.get()).map(EnergyMachineComponent::getEnergy).orElse(0L);
    }

    public void setEnergyStored(long energy) {
        this.internal.getComponentManager().getComponent(Registration.ENERGY_MACHINE_COMPONENT.get()).ifPresent(component -> component.setEnergy(energy));
    }

    public long getEnergyCapacity() {
        return this.internal.getComponentManager().getComponent(Registration.ENERGY_MACHINE_COMPONENT.get()).map(EnergyMachineComponent::getCapacity).orElse(0L);
    }

    public int addEnergy(int toAdd, boolean simulate) {
        return this.internal.getComponentManager().getComponent(Registration.ENERGY_MACHINE_COMPONENT.get()).map(component -> component.receiveRecipeEnergy(toAdd, simulate)).orElse(0);
    }

    public int removeEnergy(int toRemove, boolean simulate) {
        return this.internal.getComponentManager().getComponent(Registration.ENERGY_MACHINE_COMPONENT.get()).map(component -> component.extractRecipeEnergy(toRemove, simulate)).orElse(0);
    }

    public FluidStack getFluidStored(String tank) {
        return this.internal.getComponentManager().getComponentHandler(Registration.FLUID_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).map(FluidMachineComponent::getFluid).orElse(FluidStack.EMPTY);
    }

    public void setFluidStored(String tank, FluidStack stack) {
        this.internal.getComponentManager().getComponentHandler(Registration.FLUID_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).ifPresent(x -> x.setFluidStack(stack));
    }

    public int getFluidCapacity(String tank) {
        return this.internal.getComponentManager().getComponentHandler(Registration.FLUID_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).map(FluidMachineComponent::getCapacity).orElse(0);
    }

    public int addFluid(FluidStack stack, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler(Registration.FLUID_MACHINE_COMPONENT.get()).map(handler -> (FluidComponentHandler)handler).map(handler -> handler.fill(stack, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE)).orElse(0);
    }

    public int addFluidToTank(String tank, FluidStack stack, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler(Registration.FLUID_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).map(component -> component.fillBypassLimit(stack, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE)).orElse(stack.getAmount());
    }

    public FluidStack removeFluid(FluidStack stack, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler(Registration.FLUID_MACHINE_COMPONENT.get()).map(handler -> (FluidComponentHandler)handler).map(handler -> handler.drain(stack, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE)).orElse(FluidStack.EMPTY);
    }

    public FluidStack removeFluidFromTank(String tank, int amount, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler(Registration.FLUID_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(tank)).map(component -> component.drainBypassLimit(amount, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE)).orElse(FluidStack.EMPTY);
    }

    public ItemStack getItemStored(String slot) {
        return this.internal.getComponentManager().getComponentHandler(Registration.ITEM_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(slot)).map(ItemMachineComponent::getItemStack).orElse(ItemStack.EMPTY);
    }

    public void setItemStored(String slot, ItemStack stack) {
        this.internal.getComponentManager().getComponentHandler(Registration.ITEM_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(slot)).ifPresent(component -> component.setItemStack(stack));
    }

    public int getItemCapacity(String slot) {
        return this.internal.getComponentManager().getComponentHandler(Registration.ITEM_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(slot)).map(ItemMachineComponent::getCapacity).orElse(0);
    }

    public ItemStack addItemToSlot(String slot, ItemStack stack, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler(Registration.ITEM_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(slot)).map(component -> component.insertItemBypassLimit(stack, simulate)).orElse(stack);
    }

    public ItemStack removeItemFromSlot(String slot, int toRemove, boolean simulate) {
        return this.internal.getComponentManager().getComponentHandler(Registration.ITEM_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(slot)).map(component -> component.extractItemBypassLimit(toRemove, simulate)).orElse(ItemStack.EMPTY);
    }

    public void lockSlot(String slot) {
        this.internal.getComponentManager().getComponentHandler(Registration.ITEM_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(slot)).ifPresent(component -> component.setLocked(true));
    }

    public void unlockSlot(String slot) {
        this.internal.getComponentManager().getComponentHandler(Registration.ITEM_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(slot)).ifPresent(component -> component.setLocked(false));
    }

    public boolean isSlotLocked(String slot) {
        return this.internal.getComponentManager().getComponentHandler(Registration.ITEM_MACHINE_COMPONENT.get()).flatMap(handler -> handler.getComponentForID(slot)).map(ItemMachineComponent::isLocked).orElseThrow(() -> new IllegalArgumentException("Invalid slot id: " + slot));
    }

    public void enableChunkload(int radius) {
        this.internal.getComponentManager().getComponent(Registration.CHUNKLOAD_MACHINE_COMPONENT.get()).ifPresent(component -> component.setActive((ServerLevel)this.internal.getLevel(), radius));
    }

    public void disableChunkload() {
        this.internal.getComponentManager().getComponent(Registration.CHUNKLOAD_MACHINE_COMPONENT.get()).ifPresent(component -> component.setInactive((ServerLevel)this.internal.getLevel()));
    }

    public boolean isChunkloadEnabled() {
        return this.internal.getComponentManager().getComponent(Registration.CHUNKLOAD_MACHINE_COMPONENT.get()).map(ChunkloadMachineComponent::isActive).orElse(false);
    }

    public int getChunkloadRadius() {
        return this.internal.getComponentManager().getComponent(Registration.CHUNKLOAD_MACHINE_COMPONENT.get()).map(ChunkloadMachineComponent::getRadius).orElse(0);
    }
}

