/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.kubejs.requirements;

import fr.frinn.custommachinery.api.integration.kubejs.RecipeJSBuilder;
import fr.frinn.custommachinery.common.requirement.EffectRequirement;
import fr.frinn.custommachinery.common.util.Utils;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;

public interface EffectRequirementJS
extends RecipeJSBuilder {
    default public RecipeJSBuilder giveEffectOnEnd(String effect, int time, int radius) {
        return this.giveEffectOnEnd(effect, time, radius, 1, new String[0]);
    }

    default public RecipeJSBuilder giveEffectOnEnd(String effect, int time, int radius, int level) {
        return this.giveEffectOnEnd(effect, time, radius, level, new String[0]);
    }

    default public RecipeJSBuilder giveEffectOnEnd(String effect, int time, int radius, String[] filter) {
        return this.giveEffectOnEnd(effect, time, radius, 1, filter);
    }

    default public RecipeJSBuilder giveEffectOnEnd(String effect, int time, int radius, int level, String[] filter) {
        ArrayList entityFilter = new ArrayList();
        for (String type : filter) {
            if (!Utils.isResourceNameValid(type) || !BuiltInRegistries.ENTITY_TYPE.containsKey(ResourceLocation.parse((String)type))) {
                return this.error("Invalid entity ID: {}", type);
            }
            entityFilter.add((EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)type)));
        }
        if (Utils.isResourceNameValid(effect) && BuiltInRegistries.MOB_EFFECT.containsKey(ResourceLocation.parse((String)effect))) {
            return this.addRequirement(new EffectRequirement((Holder<MobEffect>)((Holder)BuiltInRegistries.MOB_EFFECT.getHolder(ResourceLocation.parse((String)effect)).orElseThrow()), time, level, radius, entityFilter, true));
        }
        return this.error("Invalid effect ID: {}", effect);
    }

    default public RecipeJSBuilder giveEffectEachTick(String effect, int time, int radius) {
        return this.giveEffectEachTick(effect, time, radius, 1, new String[0]);
    }

    default public RecipeJSBuilder giveEffectEachTick(String effect, int time, int radius, Object levelOrFilter) {
        if (levelOrFilter instanceof Number) {
            return this.giveEffectEachTick(effect, time, radius, ((Number)levelOrFilter).intValue(), new String[0]);
        }
        if (levelOrFilter instanceof String) {
            return this.giveEffectEachTick(effect, time, radius, 1, new String[]{(String)levelOrFilter});
        }
        if (levelOrFilter instanceof String[]) {
            return this.giveEffectEachTick(effect, time, radius, 1, (String[])levelOrFilter);
        }
        return this.error("Invalid 4th param given to 'giveEffectEachTick' : {}", levelOrFilter.toString());
    }

    default public RecipeJSBuilder giveEffectEachTick(String effect, int time, int radius, int level, String[] filter) {
        ArrayList entityFilter = new ArrayList();
        for (String type : filter) {
            if (!Utils.isResourceNameValid(type) || !BuiltInRegistries.ENTITY_TYPE.containsKey(ResourceLocation.parse((String)type))) {
                return this.error("Invalid entity ID: {}", type);
            }
            entityFilter.add((EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)type)));
        }
        if (Utils.isResourceNameValid(effect) && BuiltInRegistries.MOB_EFFECT.containsKey(ResourceLocation.parse((String)effect))) {
            return this.addRequirement(new EffectRequirement((Holder<MobEffect>)((Holder)BuiltInRegistries.MOB_EFFECT.getHolder(ResourceLocation.parse((String)effect)).orElseThrow()), time, level, radius, entityFilter, false));
        }
        return this.error("Invalid effect ID: {}", effect);
    }
}

