/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.kubejs.requirements;

import fr.frinn.custommachinery.api.integration.kubejs.RecipeJSBuilder;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.common.requirement.ItemRequirement;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public interface ItemRequirementJS
extends RecipeJSBuilder {
    default public RecipeJSBuilder requireItem(SizedIngredient ingredient) {
        return this.requireItem(ingredient, "");
    }

    default public RecipeJSBuilder requireItem(SizedIngredient ingredient, String slot) {
        if (ingredient.getItems().length == 0) {
            return this.error("Invalid empty ingredient in item input requirement", new Object[0]);
        }
        return this.addRequirement(new ItemRequirement(RequirementIOMode.INPUT, ingredient, slot));
    }

    default public RecipeJSBuilder produceItem(ItemStack stack) {
        return this.produceItem(stack, "");
    }

    default public RecipeJSBuilder produceItem(ItemStack stack, String slot) {
        if (stack.isEmpty()) {
            return this.error("Invalid empty item in item output requirement", new Object[0]);
        }
        return this.addRequirement(new ItemRequirement(RequirementIOMode.OUTPUT, new SizedIngredient(DataComponentIngredient.of((boolean)true, (ItemStack)stack), stack.getCount()), slot));
    }
}

