/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.machine;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import fr.frinn.custommachinery.api.ICustomMachineryAPI;
import fr.frinn.custommachinery.api.machine.IMachineAppearance;
import fr.frinn.custommachinery.api.machine.MachineAppearanceProperty;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.MachineShape;
import fr.frinn.custommachinery.common.util.sound.AmbientSound;
import fr.frinn.custommachinery.impl.codec.NamedMapCodec;
import fr.frinn.custommachinery.impl.util.IMachineModelLocation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MachineAppearance
implements IMachineAppearance {
    public static final NamedMapCodec<Map<MachineAppearanceProperty<?>, Object>> CODEC = new NamedMapCodec<Map<MachineAppearanceProperty<?>, Object>>(){

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Registration.APPEARANCE_PROPERTY_REGISTRY.keys(ops);
        }

        @Override
        public <T> DataResult<Map<MachineAppearanceProperty<?>, Object>> decode(DynamicOps<T> ops, MapLike<T> input) {
            ImmutableMap.Builder properties = ImmutableMap.builder();
            for (MachineAppearanceProperty property : Registration.APPEARANCE_PROPERTY_REGISTRY) {
                DataResult result;
                if (property.getId() != null && input.get(property.getId().toString()) != null) {
                    result = property.getCodec().read(ops, input.get(property.getId().toString()));
                    if (result.result().isPresent()) {
                        properties.put((Object)property, result.result().get());
                        continue;
                    }
                    if (!result.error().isPresent()) continue;
                    ICustomMachineryAPI.INSTANCE.logger().warn("Couldn't deserialize appearance property: {}, invalid value: {}, error: {}, using default value instead.", (Object)property.getId(), input.get(property.getId().toString()), (Object)((DataResult.Error)result.error().get()).message());
                    properties.put((Object)property, property.getDefaultValue());
                    continue;
                }
                if (property.getId() != null && input.get(property.getId().getPath()) != null) {
                    result = property.getCodec().read(ops, input.get(property.getId().getPath()));
                    if (result.result().isPresent()) {
                        properties.put((Object)property, result.result().get());
                        continue;
                    }
                    if (!result.error().isPresent()) continue;
                    ICustomMachineryAPI.INSTANCE.logger().warn("Couldn't deserialize appearance property: {}, invalid value: {}, error: {}, using default value instead.", (Object)property.getId(), input.get(property.getId().getPath()), (Object)((DataResult.Error)result.error().get()).message());
                    properties.put((Object)property, property.getDefaultValue());
                    continue;
                }
                properties.put((Object)property, property.getDefaultValue());
            }
            return DataResult.success((Object)properties.build());
        }

        public <T> RecordBuilder<T> encode(Map<MachineAppearanceProperty<?>, Object> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            for (Map.Entry<MachineAppearanceProperty<?>, Object> entry : input.entrySet()) {
                if (Objects.equals(entry.getValue(), entry.getKey().getDefaultValue()) || entry.getKey().getId() == null) continue;
                prefix.add(entry.getKey().getId().toString(), entry.getKey().getCodec().encodeStart(ops, entry.getValue()));
            }
            return prefix;
        }

        @Override
        public String name() {
            return "Machine Appearance";
        }
    };
    public static final MachineAppearance DEFAULT = new MachineAppearance(MachineAppearance.defaultProperties());
    private final Map<MachineAppearanceProperty<?>, Object> properties;

    public MachineAppearance(Map<MachineAppearanceProperty<?>, Object> properties) {
        this.properties = properties;
    }

    @Override
    public <T> T getProperty(MachineAppearanceProperty<T> property) {
        if (!this.properties.containsKey(property)) {
            return property.getDefaultValue();
        }
        return (T)this.properties.get(property);
    }

    @Override
    public IMachineModelLocation getBlockModel() {
        return this.getProperty(Registration.BLOCK_MODEL_PROPERTY.get());
    }

    @Override
    public IMachineModelLocation getItemModel() {
        return this.getProperty(Registration.ITEM_MODEL_PROPERTY.get());
    }

    @Override
    public AmbientSound getAmbientSound() {
        return this.getProperty(Registration.AMBIENT_SOUND_PROPERTY.get());
    }

    @Override
    public SoundType getInteractionSound() {
        return this.getProperty(Registration.INTERACTION_SOUND_PROPERTY.get());
    }

    @Override
    public int getLightLevel() {
        return this.getProperty(Registration.LIGHT_PROPERTY.get());
    }

    @Override
    public int getColor() {
        return this.getProperty(Registration.COLOR_PROPERTY.get());
    }

    @Override
    public float getHardness() {
        return this.getProperty(Registration.HARDNESS_PROPERTY.get()).floatValue();
    }

    @Override
    public float getResistance() {
        return this.getProperty(Registration.RESISTANCE_PROPERTY.get()).floatValue();
    }

    @Override
    public List<TagKey<Block>> getTool() {
        return this.getProperty(Registration.TOOL_TYPE_PROPERTY.get());
    }

    @Override
    public TagKey<Block> getMiningLevel() {
        return this.getProperty(Registration.MINING_LEVEL_PROPERTY.get());
    }

    @Override
    public boolean requiresCorrectToolForDrops() {
        return this.getProperty(Registration.REQUIRES_TOOL.get());
    }

    public MachineShape getShape() {
        return this.getProperty(Registration.SHAPE_PROPERTY.get());
    }

    @Override
    public Function<Direction, VoxelShape> getCollisionShape() {
        MachineShape collisionShape = this.getProperty(Registration.SHAPE_COLLISION_PROPERTY.get());
        if (collisionShape == MachineShape.DEFAULT_COLLISION) {
            return this.getShape();
        }
        return collisionShape;
    }

    @Override
    public boolean shouldKeepInventory() {
        return this.getProperty(Registration.KEEP_INVENTORY_PROPERTY.get());
    }

    @Override
    public MachineAppearance copy() {
        return new MachineAppearance((Map<MachineAppearanceProperty<?>, Object>)ImmutableMap.copyOf(this.properties));
    }

    public Map<MachineAppearanceProperty<?>, Object> getProperties() {
        return this.properties;
    }

    public static Map<MachineAppearanceProperty<?>, Object> defaultProperties() {
        HashMap map = new HashMap();
        for (MachineAppearanceProperty property : Registration.APPEARANCE_PROPERTY_REGISTRY) {
            map.put(property, property.getDefaultValue());
        }
        return map;
    }
}

