/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.machine;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.impl.codec.DefaultCodecs;
import java.io.File;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.fml.loading.FMLLoader;
import org.jetbrains.annotations.Nullable;

public class MachineLocation {
    public static final NamedCodec<MachineLocation> CODEC = NamedCodec.record(machineLocationInstance -> machineLocationInstance.group(DefaultCodecs.RESOURCE_LOCATION.fieldOf("id").forGetter(MachineLocation::getId), Loader.CODEC.fieldOf("loader").forGetter(MachineLocation::getLoader), NamedCodec.STRING.fieldOf("packName").forGetter(MachineLocation::getPackName)).apply((Applicative)machineLocationInstance, MachineLocation::new), "Machine location");
    private final ResourceLocation id;
    private final Loader loader;
    private final String packName;

    private MachineLocation(ResourceLocation id, Loader loader, String packName) {
        this.id = id;
        this.loader = loader;
        this.packName = packName;
    }

    public static MachineLocation fromLoader(Loader loader, ResourceLocation id, String packName) {
        return switch (loader.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> MachineLocation.fromDefault(id, packName);
            case 1 -> MachineLocation.fromDatapack(id, packName);
            case 2 -> MachineLocation.fromDatapackZip(id, packName);
            case 3 -> MachineLocation.fromKubeJS(id, packName);
            case 4 -> MachineLocation.fromKubeJSScript(id, packName);
        };
    }

    public static MachineLocation fromDefault(ResourceLocation id, String packName) {
        return new MachineLocation(id, Loader.DEFAULT, packName);
    }

    public static MachineLocation fromDatapack(ResourceLocation id, String packName) {
        if (packName.startsWith("file")) {
            packName = packName.substring(5);
        }
        return new MachineLocation(id, Loader.DATAPACK, packName);
    }

    public static MachineLocation fromDatapackZip(ResourceLocation id, String packName) {
        return new MachineLocation(id, Loader.DATAPACK_ZIP, packName);
    }

    public static MachineLocation fromKubeJS(ResourceLocation id, String packName) {
        return new MachineLocation(id, Loader.KUBEJS, packName);
    }

    public static MachineLocation fromKubeJSScript(ResourceLocation id, String packName) {
        return new MachineLocation(id, Loader.KUBEJS_SCRIPT, packName);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public Loader getLoader() {
        return this.loader;
    }

    public String getPackName() {
        return this.packName;
    }

    @Nullable
    public File getFile(MinecraftServer server) {
        String pathFromData = "data" + File.separator + this.id.getNamespace() + File.separator + "machine" + File.separator + this.id.getPath() + ".json";
        Object root = server.getServerDirectory().toFile().getAbsolutePath();
        if (!FMLLoader.isProduction()) {
            root = ((String)root).substring(0, ((String)root).length() - 2);
        }
        root = (String)root + File.separator + "kubejs" + File.separator + "data" + File.separator + this.getId().getNamespace() + File.separator + "machine";
        File kubeJS = new File((String)root, this.getId().getPath() + ".json");
        return switch (this.loader.ordinal()) {
            case 1 -> server.getWorldPath(LevelResource.DATAPACK_DIR).resolve(this.packName + File.separator + pathFromData).normalize().toFile();
            case 3 -> kubeJS;
            default -> null;
        };
    }

    public boolean canEdit() {
        return this.loader.canEdit;
    }

    public MutableComponent getText() {
        return this.loader.getTranslatedName().append((Component)Component.literal((String)(" : " + this.packName)));
    }

    public static enum Loader {
        DEFAULT(false, ChatFormatting.BLACK),
        DATAPACK(true, ChatFormatting.DARK_GREEN),
        DATAPACK_ZIP(false, ChatFormatting.DARK_RED),
        KUBEJS(true, ChatFormatting.DARK_PURPLE),
        KUBEJS_SCRIPT(false, ChatFormatting.DARK_RED);

        public static final NamedCodec<Loader> CODEC;
        private final boolean canEdit;
        private final ChatFormatting color;

        private Loader(boolean canEdit, ChatFormatting color) {
            this.canEdit = canEdit;
            this.color = color;
        }

        public MutableComponent getTranslatedName() {
            return Component.translatable((String)("custommachinery.machine.loader." + this.name().toLowerCase(Locale.ROOT))).withStyle(this.color);
        }

        static {
            CODEC = NamedCodec.enumCodec(Loader.class);
        }
    }
}

