/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network;

import fr.frinn.custommachinery.api.network.DataType;
import fr.frinn.custommachinery.api.network.IData;
import fr.frinn.custommachinery.api.network.ISyncable;
import fr.frinn.custommachinery.api.network.ISyncableStuff;
import fr.frinn.custommachinery.common.network.SUpdateContainerPacket;
import fr.frinn.custommachinery.common.network.syncable.IntegerSyncable;
import fr.frinn.custommachinery.common.network.syncable.ItemStackSyncable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public abstract class SyncableContainer
extends AbstractContainerMenu {
    private final ServerPlayer player;
    private final List<ISyncable<?, ?>> stuffToSync = new ArrayList();
    private final ISyncableStuff syncableStuff;

    public SyncableContainer(@Nullable MenuType<?> type, int id, ISyncableStuff syncableStuff, Player player) {
        super(type, id);
        ServerPlayer serverPlayer;
        this.player = player instanceof ServerPlayer ? (serverPlayer = (ServerPlayer)player) : null;
        this.syncableStuff = syncableStuff;
    }

    public void init() {
        this.stuffToSync.clear();
        this.stuffToSync.add(DataType.createSyncable(ItemStack.class, () -> ((SyncableContainer)this).getCarried(), arg_0 -> ((SyncableContainer)this).setCarried(arg_0)));
        this.syncableStuff.getStuffToSync(this.stuffToSync::add);
    }

    public abstract boolean needFullSync();

    public void broadcastChanges() {
        if (this.player != null) {
            if (this.needFullSync()) {
                ArrayList toSync = new ArrayList();
                for (short id = 0; id < this.stuffToSync.size(); id = (short)(id + 1)) {
                    toSync.add((IData<?>)this.stuffToSync.get(id).getData(id));
                }
                PacketDistributor.sendToPlayer((ServerPlayer)this.player, (CustomPacketPayload)new SUpdateContainerPacket(this.containerId, toSync), (CustomPacketPayload[])new CustomPacketPayload[0]);
                return;
            }
            ArrayList toSync = new ArrayList();
            for (short id = 0; id < this.stuffToSync.size(); id = (short)((short)(id + 1))) {
                if (!this.stuffToSync.get(id).needSync()) continue;
                toSync.add((IData<?>)this.stuffToSync.get(id).getData(id));
            }
            if (!toSync.isEmpty()) {
                PacketDistributor.sendToPlayer((ServerPlayer)this.player, (CustomPacketPayload)new SUpdateContainerPacket(this.containerId, toSync), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public void handleData(IData<?> data) {
        short id = data.getID();
        ISyncable<?, ?> syncable = this.stuffToSync.get(id);
        if (syncable != null) {
            syncable.set(data.getValue());
        }
    }

    protected DataSlot addDataSlot(DataSlot intReferenceHolder) {
        this.stuffToSync.add(IntegerSyncable.create(() -> ((DataSlot)intReferenceHolder).get(), arg_0 -> ((DataSlot)intReferenceHolder).set(arg_0)));
        return intReferenceHolder;
    }

    protected void addDataSlots(ContainerData array) {
        int i = 0;
        while (i < array.getCount()) {
            int index = i++;
            this.stuffToSync.add(IntegerSyncable.create(() -> array.get(index), integer -> array.set(index, integer.intValue())));
        }
    }

    public void initializeContents(int stateId, List<ItemStack> items, ItemStack carried) {
    }

    protected Slot addSyncedSlot(Slot slot) {
        this.stuffToSync.add(ItemStackSyncable.create(() -> ((Slot)slot).getItem(), arg_0 -> ((Slot)slot).set(arg_0)));
        return this.addSlot(slot);
    }

    public ServerPlayer getPlayer() {
        return this.player;
    }
}

