/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.requirement;

import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.crafting.IRequirementList;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfo;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.api.requirement.RecipeRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.client.ClientHandler;
import fr.frinn.custommachinery.client.render.CustomMachineRenderer;
import fr.frinn.custommachinery.common.component.StructureMachineComponent;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.network.CPlaceStructurePacket;
import fr.frinn.custommachinery.common.util.BlockStructure;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.common.util.ingredient.IIngredient;
import fr.frinn.custommachinery.impl.codec.DefaultCodecs;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.network.PacketDistributor;

public record StructureRequirement(List<List<String>> pattern, Map<Character, IIngredient<PartialBlockState>> keys, Action action, BlockStructure structure) implements IRequirement<StructureMachineComponent>
{
    public static final NamedCodec<StructureRequirement> CODEC = NamedCodec.record(structureRequirementInstance -> structureRequirementInstance.group(NamedCodec.STRING.listOf().listOf().fieldOf("pattern").forGetter(requirement -> requirement.pattern), NamedCodec.unboundedMap(DefaultCodecs.CHARACTER, IIngredient.BLOCK, "Map<Character, Block>").fieldOf("keys").forGetter(requirement -> requirement.keys), NamedCodec.enumCodec(Action.class).optionalFieldOf("action", Action.CHECK).forGetter(requirement -> requirement.action)).apply((Applicative)structureRequirementInstance, StructureRequirement::new), "Structure requirement");

    public StructureRequirement(List<List<String>> pattern, Map<Character, IIngredient<PartialBlockState>> keys, Action action) {
        this(pattern, keys, action, StructureRequirement.makeStructure(pattern, keys));
    }

    private static BlockStructure makeStructure(List<List<String>> pattern, Map<Character, IIngredient<PartialBlockState>> keys) {
        BlockStructure.Builder builder = BlockStructure.Builder.start();
        for (List<String> list : pattern) {
            builder.aisle(list.toArray(new String[0]));
        }
        for (Map.Entry entry : keys.entrySet()) {
            builder.where(((Character)entry.getKey()).charValue(), (IIngredient)entry.getValue());
        }
        return builder.build();
    }

    @Override
    public RequirementType<StructureRequirement> getType() {
        return Registration.STRUCTURE_REQUIREMENT.get();
    }

    @Override
    public MachineComponentType<StructureMachineComponent> getComponentType() {
        return Registration.STRUCTURE_MACHINE_COMPONENT.get();
    }

    @Override
    public RequirementIOMode getMode() {
        return RequirementIOMode.INPUT;
    }

    @Override
    public boolean test(StructureMachineComponent component, ICraftingContext context) {
        return switch (this.action.ordinal()) {
            case 0, 1, 2 -> component.checkStructure(this.structure);
            default -> true;
        };
    }

    @Override
    public void gatherRequirements(IRequirementList<StructureMachineComponent> list) {
        if (this.action == Action.CHECK) {
            list.worldCondition(this::check);
        } else {
            list.processDelayed(1.0, this::process);
        }
    }

    public CraftingResult process(StructureMachineComponent component, ICraftingContext context) {
        switch (this.action.ordinal()) {
            case 2: {
                component.destroyStructure(this.structure, true);
                break;
            }
            case 1: {
                component.destroyStructure(this.structure, false);
                break;
            }
            case 3: {
                component.placeStructure(this.structure, true);
                break;
            }
            case 4: {
                component.placeStructure(this.structure, false);
            }
        }
        return CraftingResult.success();
    }

    public CraftingResult check(StructureMachineComponent component, ICraftingContext context) {
        if (component.checkStructure(this.structure)) {
            return CraftingResult.success();
        }
        return CraftingResult.error((Component)Component.translatable((String)"custommachinery.requirements.structure.error"));
    }

    @Override
    public void getDefaultDisplayInfo(IDisplayInfo info, RecipeRequirement<?, ?> requirement) {
        info.addTooltip((Component)Component.translatable((String)"custommachinery.requirements.structure.info"));
        info.addTooltip((Component)Component.translatable((String)"custommachinery.requirements.structure.click"));
        this.pattern.stream().flatMap(Collection::stream).flatMap(s -> s.chars().mapToObj(c -> Character.valueOf((char)c))).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).forEach((key, amount) -> {
            IIngredient<PartialBlockState> ingredient = this.keys.get(key);
            if (ingredient != null && amount > 0L) {
                MutableComponent block = Component.translatable((String)"custommachinery.requirements.structure.list", (Object[])new Object[]{amount, Utils.getBlockName(ingredient).withStyle(ChatFormatting.GOLD)});
                info.addTooltip((Component)Component.literal((String)"\u2713").withStyle(ChatFormatting.GREEN).append((Component)block), (player, advancedTooltips) -> this.hasBlockItem(player, ingredient, (long)amount));
                info.addTooltip((Component)Component.literal((String)"  ").append((Component)block), (player, advancedTooltips) -> !this.hasBlockItem(player, ingredient, (long)amount));
            }
        });
        switch (this.action.ordinal()) {
            case 2: {
                info.addTooltip((Component)Component.translatable((String)"custommachinery.requirements.structure.break").withStyle(ChatFormatting.DARK_RED));
                break;
            }
            case 1: {
                info.addTooltip((Component)Component.translatable((String)"custommachinery.requirements.structure.destroy").withStyle(ChatFormatting.DARK_RED));
                break;
            }
            case 3: 
            case 4: {
                info.addTooltip((Component)Component.translatable((String)"custommachinery.requirements.structure.place").withStyle(ChatFormatting.DARK_RED));
            }
        }
        info.addTooltip((Component)Component.translatable((String)"custommachinery.requirements.structure.creative").withStyle(ChatFormatting.DARK_PURPLE), IDisplayInfo.TooltipPredicate.CREATIVE);
        info.setClickAction((machine, recipe, mouseButton) -> {
            if (ClientHandler.isShiftKeyDown()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new CPlaceStructurePacket(machine.getId(), this.pattern, this.keys), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                CustomMachineRenderer.addRenderBlock(machine.getId(), this.structure::getBlocks);
            }
        });
        info.setItemIcon(Items.STRUCTURE_BLOCK);
    }

    private boolean hasBlockItem(Player player, IIngredient<PartialBlockState> block, long amount) {
        return player.getInventory().items.stream().filter(stack -> stack.getItem() instanceof BlockItem && block.test(new PartialBlockState(((BlockItem)stack.getItem()).getBlock()))).mapToLong(ItemStack::getCount).sum() >= amount;
    }

    public static enum Action {
        CHECK,
        DESTROY,
        BREAK,
        PLACE_BREAK,
        PLACE_DESTROY;

    }
}

