/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.upgrade;

import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.ICustomMachineryAPI;
import fr.frinn.custommachinery.common.integration.kubejs.KubeJSIntegration;
import fr.frinn.custommachinery.common.upgrade.MachineUpgrade;
import fr.frinn.custommachinery.common.util.CustomJsonReloadListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Items;
import net.neoforged.fml.ModList;
import org.apache.logging.log4j.Logger;

public class UpgradesCustomReloadListener
extends CustomJsonReloadListener {
    private static final String MAIN_PACKNAME = "main";

    public UpgradesCustomReloadListener() {
        super("upgrade", "upgrades");
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profiler) {
        Logger logger = ICustomMachineryAPI.INSTANCE.logger();
        ArrayList<MachineUpgrade> upgrades = new ArrayList<MachineUpgrade>();
        logger.info("Reading Custom Machinery Upgrades json");
        map.forEach((id, json) -> {
            String packName;
            try {
                packName = resourceManager.getResourceOrThrow(ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("upgrades/" + id.getPath() + ".json"))).sourcePackId();
            }
            catch (IOException e) {
                packName = MAIN_PACKNAME;
            }
            logger.info("Parsing upgrade json: {} in datapack: {}", id, (Object)packName);
            if (!json.isJsonObject()) {
                logger.error("Bad upgrade JSON: {} must be a json object and not an array or primitive, skipping...", id);
                return;
            }
            DataResult<MachineUpgrade> result = MachineUpgrade.CODEC.read(JsonOps.INSTANCE, json);
            if (result.result().isPresent()) {
                MachineUpgrade upgrade = (MachineUpgrade)result.result().get();
                if (upgrade.getItem() == Items.AIR) {
                    logger.error("Invalid item: {}, defined for upgrade: {}", (Object)BuiltInRegistries.ITEM.getKey((Object)upgrade.getItem()), id);
                    return;
                }
                logger.info("Successfully parsed upgrade json: {}", id);
                upgrades.add(upgrade);
                return;
            }
            if (result.error().isPresent()) {
                logger.error("Error while parsing upgrade json: {}, skipping...\n{}", id, (Object)((DataResult.Error)result.error().get()).message());
                return;
            }
            throw new IllegalStateException("No success nor error when parsing machine json: " + String.valueOf(id) + ". This can't happen.");
        });
        if (!upgrades.isEmpty()) {
            logger.info("Successfully parsed {} upgrade json.", (Object)upgrades.size());
        } else {
            logger.info("No machine upgrade json found.");
        }
        if (ModList.get().isLoaded("kubejs")) {
            logger.info("Collecting machine upgrades with kubeJS.");
            List<MachineUpgrade> kubejsUpgrades = KubeJSIntegration.collectMachineUpgrades();
            if (!kubejsUpgrades.isEmpty()) {
                logger.info("Successfully added {} machine upgrades with kubejs", (Object)kubejsUpgrades.size());
            } else {
                logger.info("No machine upgrades found with kubejs");
            }
            upgrades.addAll(kubejsUpgrades);
        }
        logger.info("Finished creating custom machine upgrades.");
        CustomMachinery.UPGRADES.refresh(upgrades);
    }
}

