/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util.ingredient;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DataResult;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import fr.frinn.custommachinery.common.util.ingredient.BlockIngredient;
import fr.frinn.custommachinery.common.util.ingredient.BlockTagIngredient;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

public interface IIngredient<O>
extends Predicate<O> {
    public static final NamedCodec<IIngredient<PartialBlockState>> BLOCK = NamedCodec.either(BlockIngredient.CODEC, BlockTagIngredient.CODEC, "Block Ingredient").flatComapMap(either -> (IIngredient)either.map(Function.identity(), Function.identity()), ingredient -> {
        if (ingredient instanceof BlockIngredient) {
            return DataResult.success((Object)Either.left((Object)((BlockIngredient)ingredient)));
        }
        if (ingredient instanceof BlockTagIngredient) {
            return DataResult.success((Object)Either.right((Object)((BlockTagIngredient)ingredient)));
        }
        return DataResult.error(() -> String.format("Block Ingredient : %s is not a block nor a tag !", ingredient));
    }, "Block ingredient");

    public List<O> getAll();
}

