/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.util.sound;

import fr.frinn.custommachinery.common.util.sound.AmbientSound;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;

public class SoundManager {
    private final BlockPos pos;
    @Nullable
    private SoundInstance sound;

    public SoundManager(BlockPos pos) {
        this.pos = pos;
    }

    public boolean isCurrentlyPlaying(AmbientSound sound) {
        return this.sound != null && this.sound.getLocation().equals((Object)sound.sound().getLocation()) && this.sound.getVolume() == sound.volume() && this.sound.getPitch() == sound.pitch() && this.sound.getSource() == sound.source() && this.sound.isLooping() == sound.loop() && this.sound.getAttenuation() == (sound.attenuation() ? SoundInstance.Attenuation.LINEAR : SoundInstance.Attenuation.NONE) && this.sound.getDelay() == sound.delay() && this.sound.isRelative() == sound.relative();
    }

    public Optional<SoundInstance> getSound() {
        return Optional.ofNullable(this.sound);
    }

    public void setSound(@Nullable AmbientSound sound) {
        this.stop();
        if (sound == null) {
            this.sound = null;
            return;
        }
        this.sound = new SimpleSoundInstance(sound.sound().getLocation(), sound.source(), sound.volume(), sound.pitch(), RandomSource.create(), sound.loop(), sound.delay(), sound.attenuation() ? SoundInstance.Attenuation.LINEAR : SoundInstance.Attenuation.NONE, (double)this.pos.getX(), (double)this.pos.getY(), (double)this.pos.getZ(), sound.relative());
        this.play();
    }

    public boolean isPlaying() {
        return this.getSound().map(sound -> Minecraft.getInstance().getSoundManager().isActive(sound)).orElse(false);
    }

    public void play() {
        this.getSound().ifPresent(sound -> Minecraft.getInstance().getSoundManager().play(sound));
    }

    public void stop() {
        this.getSound().ifPresent(sound -> Minecraft.getInstance().getSoundManager().stop(sound));
    }
}

