/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.impl.component.config;

import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.impl.codec.EnumCodec;
import java.util.Locale;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public enum RelativeSide {
    TOP,
    BOTTOM,
    FRONT,
    RIGHT,
    BACK,
    LEFT;

    public static final NamedCodec<RelativeSide> CODEC;

    public Component getTranslationName() {
        return Component.translatable((String)("custommachinery.side." + this.name().toLowerCase(Locale.ROOT)));
    }

    public Direction getDirection(@NotNull Direction facing) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 2 -> facing;
            case 4 -> facing.getOpposite();
            case 5 -> {
                if (facing == Direction.DOWN || facing == Direction.UP) {
                    yield Direction.EAST;
                }
                yield facing.getClockWise();
            }
            case 3 -> {
                if (facing == Direction.DOWN || facing == Direction.UP) {
                    yield Direction.WEST;
                }
                yield facing.getCounterClockWise();
            }
            case 0 -> {
                switch (facing) {
                    case DOWN: {
                        yield Direction.NORTH;
                    }
                    case UP: {
                        yield Direction.SOUTH;
                    }
                }
                yield Direction.UP;
            }
            case 1 -> {
                switch (facing) {
                    case DOWN: {
                        yield Direction.SOUTH;
                    }
                    case UP: {
                        yield Direction.NORTH;
                    }
                }
                yield Direction.DOWN;
            }
        };
    }

    public static RelativeSide fromDirections(@NotNull Direction facing, @NotNull Direction side) {
        if (side == facing) {
            return FRONT;
        }
        if (side == facing.getOpposite()) {
            return BACK;
        }
        if (facing == Direction.DOWN || facing == Direction.UP) {
            return switch (side) {
                case Direction.NORTH -> {
                    if (facing == Direction.DOWN) {
                        yield TOP;
                    }
                    yield BOTTOM;
                }
                case Direction.SOUTH -> {
                    if (facing == Direction.DOWN) {
                        yield BOTTOM;
                    }
                    yield TOP;
                }
                case Direction.WEST -> RIGHT;
                case Direction.EAST -> LEFT;
                default -> throw new IllegalStateException("Case should have been caught earlier.");
            };
        }
        if (side == Direction.DOWN) {
            return BOTTOM;
        }
        if (side == Direction.UP) {
            return TOP;
        }
        if (side == facing.getCounterClockWise()) {
            return RIGHT;
        }
        if (side == facing.getClockWise()) {
            return LEFT;
        }
        return FRONT;
    }

    static {
        CODEC = EnumCodec.of(RelativeSide.class);
    }
}

