/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.api.upgrade;

import fr.frinn.custommachinery.api.codec.NamedCodec;
import java.util.Locale;
import net.minecraft.util.Mth;

public enum Operation {
    ADDITION,
    MULTIPLICATION,
    EXPONENTIAL;

    public static final NamedCodec<Operation> CODEC;

    public static Operation value(String value) {
        return Operation.valueOf(value.toUpperCase(Locale.ROOT));
    }

    public double apply(double original, double modifier, int upgradeAmount, double min, double max) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Mth.clamp((double)(original + modifier * (double)upgradeAmount), (double)min, (double)max);
            case 1 -> Mth.clamp((double)(original * modifier * (double)upgradeAmount), (double)min, (double)max);
            case 2 -> Mth.clamp((double)(original * Math.pow(modifier, upgradeAmount)), (double)min, (double)max);
        };
    }

    static {
        CODEC = NamedCodec.enumCodec(Operation.class);
    }
}

