/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.client.render.BoxCreatorRenderer;
import fr.frinn.custommachinery.client.render.StructureCreatorRenderer;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.util.FileUtils;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber(modid="custommachinery", value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        CustomMachinery.UPGRADES.getUpgradesForItem(event.getItemStack().getItem()).forEach(upgrade -> {
            event.getToolTip().addAll(upgrade.tooltips());
            if (Screen.hasControlDown() || Screen.hasShiftDown()) {
                MutableComponent machines = Component.empty();
                Iterator<ResourceLocation> iterator = upgrade.machines().iterator();
                while (iterator.hasNext()) {
                    CustomMachine machine = CustomMachinery.MACHINES.get(iterator.next());
                    if (machine == null) continue;
                    machines.append(machine.getName());
                    if (!iterator.hasNext()) continue;
                    machines.append(", ");
                }
                if (!machines.getString().isEmpty()) {
                    event.getToolTip().add(machines);
                }
                upgrade.recipeModifiers().stream().map(modifier -> Component.literal((String)"  ").append(modifier.tooltip())).forEach(event.getToolTip()::add);
                upgrade.components().stream().map(modifier -> Component.literal((String)"  ").append(modifier.tooltip())).forEach(event.getToolTip()::add);
                upgrade.coreModifier().ifPresent(modifier -> event.getToolTip().add(Component.literal((String)"  ").append(modifier.tooltip())));
            }
        });
    }

    @SubscribeEvent
    public static void renderLevel(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            BoxCreatorRenderer.renderSelectedBlocks(event.getPoseStack());
            StructureCreatorRenderer.renderSelectedBlocks(event.getPoseStack());
        }
    }

    @SubscribeEvent
    public static void playerLoggedOut(ClientPlayerNetworkEvent.LoggingOut event) {
        MachineEditScreen screen;
        Screen screen2;
        if (event.getPlayer() != null && (screen2 = Minecraft.getInstance().screen) instanceof MachineEditScreen && (screen = (MachineEditScreen)screen2).isChanged()) {
            FileUtils.writeTempMachineJson(Minecraft.getInstance().gameDirectory, screen.getBuilder());
        }
    }
}

