/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.integration.jei;

import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.common.crafting.craft.CustomCraftRecipe;
import fr.frinn.custommachinery.common.crafting.machine.CustomMachineRecipe;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class CMRecipeTypes {
    private static final Map<Class<? extends IMachineRecipe>, Map<ResourceLocation, RecipeType<? extends IMachineRecipe>>> TYPES = new HashMap<Class<? extends IMachineRecipe>, Map<ResourceLocation, RecipeType<? extends IMachineRecipe>>>();

    @Nullable
    public static <T extends IMachineRecipe> RecipeType<T> get(Class<T> recipeClass, ResourceLocation id) {
        Map<ResourceLocation, RecipeType<? extends IMachineRecipe>> map = TYPES.get(recipeClass);
        if (map == null) {
            return null;
        }
        return map.get(id);
    }

    @Nullable
    public static RecipeType<CustomMachineRecipe> machine(ResourceLocation id) {
        return CMRecipeTypes.get(CustomMachineRecipe.class, id);
    }

    @Nullable
    public static RecipeType<CustomCraftRecipe> craft(ResourceLocation id) {
        return CMRecipeTypes.get(CustomCraftRecipe.class, id);
    }

    @Nullable
    public static RecipeType<? extends IMachineRecipe> fromID(ResourceLocation id) {
        return TYPES.values().stream().filter(map -> map.containsKey(id)).findFirst().map(map -> (RecipeType)map.get(id)).orElse(null);
    }

    public static <T extends IMachineRecipe> RecipeType<T> create(ResourceLocation id, Class<T> recipeClass) {
        RecipeType type = RecipeType.create((String)id.getNamespace(), (String)id.getPath(), recipeClass);
        TYPES.computeIfAbsent(recipeClass, c -> new HashMap()).put(id, type);
        return type;
    }

    public static List<RecipeType<IMachineRecipe>> all() {
        return TYPES.values().stream().flatMap(map -> map.values().stream()).map(type -> type).toList();
    }
}

