/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import fr.frinn.custommachinery.client.ClientHandler;
import fr.frinn.custommachinery.common.guielement.ProgressBarGuiElement;
import fr.frinn.custommachinery.impl.util.TextureInfo;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ProgressArrowRenderer {
    public static void renderProgressArrow(GuiGraphics graphics, ProgressBarGuiElement element, int x, int y, double progress) {
        int width = element.getWidth();
        int height = element.getHeight();
        int filledWidth = (int)((double)width * Mth.clamp((double)Mth.map((double)progress, (double)element.getStart(), (double)element.getEnd(), (double)0.0, (double)1.0), (double)0.0, (double)1.0));
        int filledHeight = (int)((double)height * Mth.clamp((double)Mth.map((double)progress, (double)element.getStart(), (double)element.getEnd(), (double)0.0, (double)1.0), (double)0.0, (double)1.0));
        if (element.getEmptyTexture().equals(ProgressBarGuiElement.BASE_EMPTY_TEXTURE) && element.getFilledTexture().equals(ProgressBarGuiElement.BASE_FILLED_TEXTURE)) {
            graphics.pose().pushPose();
            if (element.getDirection() == ProgressBarGuiElement.Orientation.TOP || element.getDirection() == ProgressBarGuiElement.Orientation.BOTTOM) {
                width = element.getHeight();
                height = element.getWidth();
                filledWidth = (int)((double)width * Mth.clamp((double)Mth.map((double)progress, (double)element.getStart(), (double)element.getEnd(), (double)0.0, (double)1.0), (double)0.0, (double)1.0));
            }
            ProgressArrowRenderer.rotate(graphics.pose(), element.getDirection(), x, y, width, height);
            ClientHandler.blit(graphics, element.getEmptyTexture(), 0, 0, width, height);
            graphics.blit(element.getFilledTexture().texture(), 0, 0, (float)element.getFilledTexture().u(), (float)element.getFilledTexture().v(), filledWidth, height, width, height);
            graphics.pose().popPose();
        } else {
            ClientHandler.blit(graphics, element.getEmptyTexture(), x, y, width, height);
            TextureInfo filled = element.getFilledTexture();
            switch (element.getDirection()) {
                case RIGHT: {
                    graphics.blit(filled.texture(), x, y, (float)filled.u(), (float)filled.v(), filledWidth, height, width, height);
                    break;
                }
                case LEFT: {
                    graphics.blit(filled.texture(), x + width - filledWidth, y, (float)(filled.u() + width - filledWidth), (float)filled.v(), filledWidth, height, width, height);
                    break;
                }
                case BOTTOM: {
                    graphics.blit(filled.texture(), x, y, (float)filled.u(), (float)filled.v(), width, filledHeight, width, height);
                    break;
                }
                case TOP: {
                    graphics.blit(filled.texture(), x, y + height - filledHeight, (float)filled.u(), (float)(filled.v() + height - filledHeight), width, filledHeight, width, height);
                }
            }
        }
    }

    public static void rotate(PoseStack matrix, ProgressBarGuiElement.Orientation orientation, int posX, int posY, int width, int height) {
        switch (orientation) {
            case RIGHT: {
                matrix.translate((float)posX, (float)posY, 0.0f);
                break;
            }
            case LEFT: {
                matrix.mulPose(new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f), 180.0f));
                matrix.translate((float)(-width - posX), (float)(-height - posY), 0.0f);
                break;
            }
            case TOP: {
                matrix.mulPose(new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f), 270.0f));
                matrix.translate((float)(-width - posY), (float)posX, 0.0f);
                break;
            }
            case BOTTOM: {
                matrix.mulPose(new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(0.0f, 0.0f, 1.0f), 90.0f));
                matrix.translate((float)posY, (float)(-height - posX), 0.0f);
            }
        }
    }
}

