/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.component;

import com.mojang.datafixers.util.Either;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.utils.Filter;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.component.ComponentBuilderPopup;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import fr.frinn.custommachinery.client.screen.widget.GridListWidget;
import fr.frinn.custommachinery.client.screen.widget.SuggestedEditBox;
import fr.frinn.custommachinery.common.util.CycleTimer;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FastColor;

public class FilterConfigPopup<T>
extends PopupScreen {
    private final Supplier<Filter<T>> supplier;
    private final Consumer<Filter<T>> consumer;
    private final FilterBuilderHelper<T> helper;
    private FilterSelectionList<T> whitelist;
    private FilterSelectionList<T> blacklist;

    public FilterConfigPopup(BaseScreen parent, Supplier<Filter<T>> supplier, Consumer<Filter<T>> consumer, FilterBuilderHelper<T> helper) {
        super(parent, 256, 196);
        this.supplier = supplier;
        this.consumer = consumer;
        this.helper = helper;
    }

    private void confirm() {
        this.consumer.accept(new Filter<T>(this.whitelist.getList(), this.blacklist.getList()));
        this.parent.closePopup(this);
    }

    private void cancel() {
        this.parent.closePopup(this);
    }

    @Override
    protected void init() {
        super.init();
        GridLayout layout = new GridLayout(this.x + 5, this.y + 5);
        GridLayout.RowHelper row = layout.createRowHelper(2);
        LayoutSettings center = layout.newCellSettings().alignHorizontallyCenter();
        row.addChild((LayoutElement)new StringWidget(this.xSize - 10, 9, (Component)Component.translatable((String)"custommachinery.gui.creation.components.filter"), this.font), 2, center);
        row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.components.filter.whitelist"), this.font), 2);
        this.whitelist = (FilterSelectionList)row.addChild(new FilterSelectionList<T>(0, 0, this.xSize - 10, 60, this.helper, this.parent, FilterSelectionList.Mode.MODIFY), 2);
        this.whitelist.setList(this.supplier.get().whitelist());
        row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.components.filter.blacklist"), this.font), 2);
        this.blacklist = (FilterSelectionList)row.addChild(new FilterSelectionList<T>(0, 0, this.xSize - 10, 60, this.helper, this.parent, FilterSelectionList.Mode.MODIFY), 2);
        this.blacklist.setList(this.supplier.get().blacklist());
        row.addChild((LayoutElement)Button.builder((Component)ComponentBuilderPopup.CONFIRM, button -> this.confirm()).size(50, 20).build(), center);
        row.addChild((LayoutElement)Button.builder((Component)ComponentBuilderPopup.CANCEL, button -> this.cancel()).size(50, 20).build(), center);
        layout.arrangeElements();
        layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    public static interface FilterBuilderHelper<T> {
        public void renderSingle(T var1, GuiGraphics var2, int var3, int var4, float var5);

        public Component tooltip(T var1);

        public Registry<T> registry();

        default public Stream<ResourceLocation> getAll() {
            return this.registry().keySet().stream();
        }

        public T defaultValue();
    }

    public static class FilterSelectionList<T>
    extends GridListWidget<FilterListEntry<T>> {
        private final FilterBuilderHelper<T> helper;
        private final BaseScreen parent;
        private final Mode mode;

        public FilterSelectionList(int x, int y, int width, int height, FilterBuilderHelper<T> helper, BaseScreen parent, Mode mode) {
            super(x, y, width, height);
            this.helper = helper;
            this.parent = parent;
            this.mode = mode;
        }

        public void setList(List<Either<TagKey<T>, Holder<T>>> list) {
            this.clear();
            list.forEach(either -> {
                either.ifLeft(tag -> this.addEntry(new TagEntry(tag, this)));
                either.ifRight(holder -> this.addEntry(new SimpleEntry(holder, this)));
            });
            if (this.mode == Mode.MODIFY) {
                this.addEntry(new AddEntry(this));
            }
        }

        public List<Either<TagKey<T>, Holder<T>>> getList() {
            ArrayList list = new ArrayList();
            this.getAll().forEach(entry -> {
                if (entry instanceof SimpleEntry) {
                    SimpleEntry simple = (SimpleEntry)entry;
                    list.add(Either.right(simple.holder));
                } else if (entry instanceof TagEntry) {
                    TagEntry tag = (TagEntry)entry;
                    list.add(Either.left(tag.tag));
                }
            });
            return list;
        }

        public static enum Mode {
            SELECT,
            MODIFY;

        }

        private static class AddEntry<T>
        extends FilterListEntry<T> {
            public static final ResourceLocation ADD_TEXTURE = CustomMachinery.rl("textures/gui/create_icon.png");

            private AddEntry(FilterSelectionList<T> list) {
                super(list);
            }

            @Override
            public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                graphics.blit(ADD_TEXTURE, 0, 0, 0.0f, 0.0f, 20, 20, 20, 20);
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                if (this.list.getSelected() == this) {
                    this.list.parent.openPopup(new FilterValueAddPopup(this.list.parent, this.list.helper, entry -> {
                        FilterListEntry filterListEntry = entry;
                        Objects.requireNonNull(filterListEntry);
                        FilterListEntry selector0$temp = filterListEntry;
                        int index$1 = 0;
                        FilterListEntry newEntry = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SimpleEntry.class, TagEntry.class}, (Object)selector0$temp, index$1)) {
                            case 0 -> {
                                SimpleEntry simpleEntry = (SimpleEntry)selector0$temp;
                                yield new SimpleEntry(simpleEntry.holder, this.list);
                            }
                            case 1 -> {
                                TagEntry tagEntry = (TagEntry)selector0$temp;
                                yield new TagEntry(tagEntry.tag, this.list);
                            }
                            default -> throw new IllegalArgumentException("Can't add " + String.valueOf(entry) + " to list, not an item or tag entry");
                        };
                        this.list.addEntry(this.list.getAll().size() - 1, newEntry);
                    }), "Add entry");
                    return true;
                }
                return super.mouseClicked(mouseX, mouseY, button);
            }

            @Override
            public List<Component> getTooltips() {
                return Collections.singletonList(Component.translatable((String)"custommachinery.gui.creation.components.filter.add"));
            }
        }

        private static class SimpleEntry<T>
        extends FilterListEntry<T> {
            private final Holder<T> holder;

            public SimpleEntry(Holder<T> holder, FilterSelectionList<T> list) {
                super(list);
                this.holder = holder;
            }

            @Override
            public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                super.render(graphics, mouseX, mouseY, partialTicks);
                graphics.pose().pushPose();
                graphics.pose().translate(2.0f, 2.0f, 0.0f);
                this.list.helper.renderSingle(this.holder.value(), graphics, mouseX, mouseY, partialTicks);
                graphics.pose().popPose();
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                if (this.list.getSelected() == this && this.list.mode == Mode.MODIFY) {
                    this.list.remove(this);
                    return true;
                }
                return super.mouseClicked(mouseX, mouseY, button);
            }

            @Override
            public List<Component> getTooltips() {
                ArrayList<Component> tooltips = new ArrayList<Component>();
                tooltips.add(this.list.helper.tooltip(this.holder.value()));
                if (this.list.mode == Mode.MODIFY) {
                    tooltips.add((Component)Component.translatable((String)"custommachinery.gui.creation.components.filter.remove").withStyle(ChatFormatting.RED));
                }
                return tooltips;
            }
        }

        private static class TagEntry<T>
        extends FilterListEntry<T> {
            private final TagKey<T> tag;
            private final CycleTimer timer = new CycleTimer(() -> 1000);

            public TagEntry(TagKey<T> tag, FilterSelectionList<T> list) {
                super(list);
                this.tag = tag;
            }

            @Override
            public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                super.render(graphics, mouseX, mouseY, partialTicks);
                this.timer.onDraw();
                Object single = this.timer.getOrDefault(this.list.helper.registry().getTag(this.tag).map(named -> named.stream().map(Holder::value).toList()).orElse(Collections.emptyList()), this.list.helper.defaultValue());
                graphics.pose().pushPose();
                graphics.pose().translate(2.0f, 2.0f, 0.0f);
                this.list.helper.renderSingle(single, graphics, mouseX, mouseY, partialTicks);
                graphics.pose().popPose();
            }

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                if (this.list.getSelected() == this && this.list.mode == Mode.MODIFY) {
                    this.list.remove(this);
                    return true;
                }
                return super.mouseClicked(mouseX, mouseY, button);
            }

            @Override
            public List<Component> getTooltips() {
                ArrayList<Component> tooltips = new ArrayList<Component>();
                tooltips.add((Component)Component.literal((String)("#" + String.valueOf(this.tag.location()))));
                if (this.list.mode == Mode.MODIFY) {
                    tooltips.add((Component)Component.translatable((String)"custommachinery.gui.creation.components.filter.remove").withStyle(ChatFormatting.RED));
                }
                return tooltips;
            }
        }

        public static abstract class FilterListEntry<T>
        extends GridListWidget.Entry {
            protected final FilterSelectionList<T> list;

            private FilterListEntry(FilterSelectionList<T> list) {
                this.list = list;
            }

            @Override
            public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                if (this.list.mode == Mode.SELECT && this.list.getSelected() == this) {
                    graphics.fill(0, 0, 20, 20, FastColor.ARGB32.color((int)255, (int)255, (int)0, (int)0));
                }
            }

            public List<? extends GuiEventListener> children() {
                return Collections.emptyList();
            }
        }
    }

    public static class FilterValueAddPopup<T>
    extends PopupScreen {
        private final FilterBuilderHelper<T> helper;
        private final Consumer<FilterSelectionList.FilterListEntry<T>> consumer;
        private Checkbox single;
        private Checkbox tag;
        private SuggestedEditBox box;
        private FilterSelectionList<T> list;

        public FilterValueAddPopup(BaseScreen parent, FilterBuilderHelper<T> helper, Consumer<FilterSelectionList.FilterListEntry<T>> consumer) {
            super(parent, 128, 128);
            this.helper = helper;
            this.consumer = consumer;
        }

        private void confirm() {
            if (this.list.getSelected() != null) {
                this.consumer.accept((FilterSelectionList.FilterListEntry)this.list.getSelected());
            }
            this.parent.closePopup(this);
        }

        private void cancel() {
            this.parent.closePopup(this);
        }

        @Override
        protected void init() {
            super.init();
            GridLayout layout = new GridLayout(this.x + 5, this.y + 5);
            GridLayout.RowHelper row = layout.createRowHelper(2);
            row.defaultCellSetting().paddingBottom(5);
            LayoutSettings center = layout.newCellSettings().alignHorizontallyCenter();
            row.addChild((LayoutElement)new StringWidget(this.xSize - 10, 9, (Component)Component.translatable((String)"custommachinery.gui.creation.components.filter.add"), this.font), 2, center);
            this.single = (Checkbox)row.addChild((LayoutElement)Checkbox.builder((Component)Component.translatable((String)"custommachinery.gui.creation.components.filter.single"), (Font)this.font).onValueChange((box, value) -> this.refreshBoxSuggestions()).selected(true).build());
            this.tag = (Checkbox)row.addChild((LayoutElement)Checkbox.builder((Component)Component.translatable((String)"custommachinery.gui.creation.components.filter.tags"), (Font)this.font).onValueChange((box, value) -> this.refreshBoxSuggestions()).selected(true).build());
            this.box = (SuggestedEditBox)row.addChild((LayoutElement)new SuggestedEditBox(this.font, 0, 0, this.xSize - 10, 20, (Component)Component.empty(), 5), 2);
            this.box.setAnchorToBottom();
            this.box.setMaxLength(Integer.MAX_VALUE);
            this.box.moveCursorToStart(false);
            this.list = (FilterSelectionList)row.addChild(new FilterSelectionList<T>(0, 0, this.xSize - 10, 60, this.helper, this.parent, FilterSelectionList.Mode.SELECT), 2, center);
            this.box.setResponder(s -> this.refreshList());
            this.refreshBoxSuggestions();
            row.addChild((LayoutElement)Button.builder((Component)ComponentBuilderPopup.CONFIRM, button -> this.confirm()).size(50, 20).build(), center);
            row.addChild((LayoutElement)Button.builder((Component)ComponentBuilderPopup.CANCEL, button -> this.cancel()).size(50, 20).build(), center);
            layout.arrangeElements();
            layout.visitWidgets(x$0 -> {
                AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
            });
            this.ySize = layout.getHeight() + 10;
        }

        private void refreshBoxSuggestions() {
            this.box.clearSuggestions();
            if (this.single.selected()) {
                this.box.addSuggestions(this.helper.getAll().map(ResourceLocation::toString).toList());
            }
            if (this.tag.selected()) {
                this.box.addSuggestions(this.helper.registry().getTagNames().map(key -> "#" + String.valueOf(key.location())).toList());
            }
            this.refreshList();
        }

        public void refreshList() {
            List<String> suggestions = this.box.getPossibleSuggestions();
            String input = this.box.getValue();
            List list = suggestions.stream().sorted(Comparator.comparingInt(s -> {
                if (s.equals(input)) {
                    return -1000;
                }
                if (s.startsWith(input)) {
                    return -100;
                }
                if (s.contains(input)) {
                    return -10;
                }
                int matchingChars = 0;
                for (char c : input.toCharArray()) {
                    if (!s.contains("" + c)) continue;
                    ++matchingChars;
                }
                return -matchingChars;
            })).limit(100L).map(s -> {
                if (s.startsWith("#")) {
                    return Either.left((Object)TagKey.create((ResourceKey)this.helper.registry().key(), (ResourceLocation)ResourceLocation.parse((String)s.substring(1))));
                }
                return Either.right((Object)((Holder)this.helper.registry().getHolder(ResourceLocation.parse((String)s)).orElseThrow()));
            }).toList();
            this.list.setList(list);
        }
    }
}

