/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.component.builder;

import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.utils.Filter;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.client.screen.creation.component.ComponentBuilderPopup;
import fr.frinn.custommachinery.client.screen.creation.component.ComponentConfigBuilderWidget;
import fr.frinn.custommachinery.client.screen.creation.component.FilterConfigPopup;
import fr.frinn.custommachinery.client.screen.creation.component.IMachineComponentBuilder;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import fr.frinn.custommachinery.client.screen.widget.IntegerSlider;
import fr.frinn.custommachinery.common.component.item.ItemMachineComponent;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.impl.component.config.IOSideConfig;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public class ItemComponentBuilder
implements IMachineComponentBuilder<ItemMachineComponent, ItemMachineComponent.Template> {
    @Override
    public MachineComponentType<ItemMachineComponent> type() {
        return Registration.ITEM_MACHINE_COMPONENT.get();
    }

    @Override
    public PopupScreen makePopup(MachineEditScreen parent, @Nullable ItemMachineComponent.Template template, Consumer<ItemMachineComponent.Template> onFinish) {
        return new ItemComponentBuilderPopup((BaseScreen)parent, template, onFinish);
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y, int width, int height, ItemMachineComponent.Template template) {
        graphics.renderFakeItem(Items.DIAMOND.getDefaultInstance(), x, y + height / 2 - 8);
        graphics.drawString(Minecraft.getInstance().font, "type: " + template.getType().getId().getPath(), x + 25, y + 5, 0, false);
        graphics.drawString(Minecraft.getInstance().font, "id: \"" + template.getId() + "\"", x + 25, y + 15, FastColor.ARGB32.color((int)255, (int)128, (int)0, (int)0), false);
        graphics.drawString(Minecraft.getInstance().font, "mode: " + String.valueOf((Object)template.mode), x + 25, y + 25, FastColor.ARGB32.color((int)255, (int)0, (int)0, (int)128), false);
    }

    public static class ItemComponentBuilderPopup
    extends ComponentBuilderPopup<ItemMachineComponent.Template> {
        protected EditBox id;
        protected CycleButton<ComponentIOMode> mode;
        protected IntegerSlider capacity;
        protected IntegerSlider maxInput;
        protected IntegerSlider maxOutput;
        protected Filter<Item> filter;
        protected Checkbox locked;
        protected IOSideConfig.Template config;

        public ItemComponentBuilderPopup(BaseScreen parent, @Nullable ItemMachineComponent.Template template, Consumer<ItemMachineComponent.Template> onFinish) {
            super(parent, template, onFinish, (Component)Component.translatable((String)"custommachinery.gui.creation.components.item.title"));
        }

        @Override
        public ItemMachineComponent.Template makeTemplate() {
            return new ItemMachineComponent.Template(this.id.getValue(), (ComponentIOMode)((Object)this.mode.getValue()), this.capacity.intValue(), Optional.of(this.maxInput.intValue()), Optional.of(this.maxOutput.intValue()), this.filter, Optional.of(this.config), this.locked.selected());
        }

        @Override
        public Component canCreate() {
            MachineEditScreen screen;
            if (this.id.getValue().isEmpty()) {
                return Component.translatable((String)"custommachinery.gui.creation.gui.id.missing");
            }
            BaseScreen baseScreen = this.parent;
            if (baseScreen instanceof MachineEditScreen && (screen = (MachineEditScreen)baseScreen).getBuilder().getComponents().stream().anyMatch(template -> template.getType() == Registration.ITEM_MACHINE_COMPONENT.get() && this.baseTemplate().map(base -> base != template).orElse(true) != false && template.getId().equals(this.id.getValue()))) {
                return Component.translatable((String)"custommachinery.gui.creation.gui.id.duplicate", (Object[])new Object[]{this.id.getValue()});
            }
            return Component.empty();
        }

        @Override
        protected void init() {
            super.init();
            this.id = this.propertyList.add((Component)Component.translatable((String)"custommachinery.gui.creation.components.id"), new EditBox(Minecraft.getInstance().font, 0, 0, 180, 20, (Component)Component.translatable((String)"custommachinery.gui.creation.components.id")));
            this.baseTemplate().ifPresentOrElse(template -> this.id.setValue(template.getId()), () -> this.id.setValue("input"));
            this.id.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.components.id.tooltip")));
            this.mode = this.propertyList.add((Component)Component.translatable((String)"custommachinery.gui.creation.components.mode"), CycleButton.builder(ComponentIOMode::toComponent).displayOnlyValue().withValues((Object[])ComponentIOMode.values()).withInitialValue((Object)ComponentIOMode.BOTH).create(0, 0, 180, 20, (Component)Component.translatable((String)"custommachinery.gui.creation.components.mode")));
            this.baseTemplate().ifPresent(template -> this.mode.setValue((Object)template.mode));
            this.capacity = this.propertyList.add((Component)Component.translatable((String)"custommachinery.gui.creation.components.capacity"), IntegerSlider.builder().bounds(0, 64).defaultValue(64).create(0, 0, 180, 20, (Component)Component.translatable((String)"custommachinery.gui.creation.components.capacity")));
            this.baseTemplate().ifPresent(template -> this.capacity.setValue(template.capacity));
            this.maxInput = this.propertyList.add((Component)Component.translatable((String)"custommachinery.gui.creation.components.maxInput"), IntegerSlider.builder().bounds(0, 64).defaultValue(64).create(0, 0, 180, 20, (Component)Component.translatable((String)"custommachinery.gui.creation.components.maxInput")));
            this.baseTemplate().ifPresent(template -> this.maxInput.setValue(template.maxInput));
            this.maxOutput = this.propertyList.add((Component)Component.translatable((String)"custommachinery.gui.creation.components.maxOutput"), IntegerSlider.builder().bounds(0, 64).defaultValue(64).create(0, 0, 180, 20, (Component)Component.translatable((String)"custommachinery.gui.creation.components.maxOutput")));
            this.baseTemplate().ifPresent(template -> this.maxOutput.setValue(template.maxOutput));
            this.baseTemplate().ifPresentOrElse(template -> {
                this.filter = template.filter;
            }, () -> {
                this.filter = Filter.empty();
            });
            this.propertyList.add((Component)Component.translatable((String)"custommachinery.gui.creation.components.filter"), Button.builder((Component)Component.translatable((String)"custommachinery.gui.creation.components.filter"), button -> this.parent.openPopup(new FilterConfigPopup<Item>(this.parent, () -> this.filter, filter -> {
                this.filter = filter;
            }, new ItemFilterHelper()), "Item Filter")).size(180, 20).build());
            this.locked = this.propertyList.add((Component)Component.translatable((String)"custommachinery.gui.creation.components.item.locked"), Checkbox.builder((Component)Component.translatable((String)"custommachinery.gui.creation.components.item.locked"), (Font)this.font).selected(false).build());
            if (this.baseTemplate().map(template -> template.locked).orElse(false).booleanValue() != this.locked.selected()) {
                this.locked.onPress();
            }
            this.locked.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.components.item.locked.tooltip")));
            this.baseTemplate().ifPresentOrElse(template -> {
                this.config = template.config;
            }, () -> {
                this.config = IOSideConfig.Template.DEFAULT_ALL_INPUT;
            });
            this.propertyList.add((Component)Component.translatable((String)"custommachinery.gui.config.component"), ComponentConfigBuilderWidget.make(0, 0, 180, 20, (Component)Component.translatable((String)"custommachinery.gui.config.component"), this.parent, () -> this.config, template -> {
                this.config = template;
            }));
        }
    }

    private static class ItemFilterHelper
    implements FilterConfigPopup.FilterBuilderHelper<Item> {
        private ItemFilterHelper() {
        }

        @Override
        public void renderSingle(Item single, GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            graphics.renderFakeItem(single.getDefaultInstance(), 0, 0);
        }

        @Override
        public Component tooltip(Item single) {
            return single.getDescription();
        }

        @Override
        public Registry<Item> registry() {
            return BuiltInRegistries.ITEM;
        }

        @Override
        public Item defaultValue() {
            return Items.BARRIER;
        }
    }
}

