/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.gui.builder;

import com.mojang.blaze3d.systems.RenderSystem;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.guielement.GuiElementType;
import fr.frinn.custommachinery.client.ClientHandler;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.client.screen.creation.gui.GuiElementBuilderPopup;
import fr.frinn.custommachinery.client.screen.creation.gui.IGuiElementBuilder;
import fr.frinn.custommachinery.client.screen.creation.gui.MutableProperties;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import fr.frinn.custommachinery.client.screen.widget.GroupWidget;
import fr.frinn.custommachinery.client.screen.widget.IntegerSlider;
import fr.frinn.custommachinery.client.screen.widget.SuggestedEditBox;
import fr.frinn.custommachinery.common.guielement.SlotGuiElement;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Color;
import fr.frinn.custommachinery.common.util.GhostItem;
import fr.frinn.custommachinery.impl.guielement.AbstractGuiElement;
import fr.frinn.custommachinery.impl.util.FakeItemRenderer;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class SlotGuiElementBuilder
implements IGuiElementBuilder<SlotGuiElement> {
    @Override
    public GuiElementType<SlotGuiElement> type() {
        return Registration.SLOT_GUI_ELEMENT.get();
    }

    @Override
    public SlotGuiElement make(AbstractGuiElement.Properties properties, @Nullable SlotGuiElement from) {
        if (from != null) {
            return new SlotGuiElement(properties, from.getGhost());
        }
        return new SlotGuiElement(properties, GhostItem.EMPTY);
    }

    @Override
    public PopupScreen makeConfigPopup(MachineEditScreen parent, MutableProperties properties, SlotGuiElement from, Consumer<SlotGuiElement> onFinish) {
        return new SlotGuiElementBuilderPopup((BaseScreen)parent, properties, from, onFinish);
    }

    public static class SlotGuiElementBuilderPopup
    extends GuiElementBuilderPopup<SlotGuiElement> {
        private GhostItemWidget ghostItem;

        public SlotGuiElementBuilderPopup(BaseScreen parent, MutableProperties properties, @Nullable SlotGuiElement from, Consumer<SlotGuiElement> onFinish) {
            super(parent, properties, from, onFinish);
        }

        @Override
        public SlotGuiElement makeElement() {
            return new SlotGuiElement(this.properties.build(), this.ghostItem.getGhost());
        }

        @Override
        public Component canCreate() {
            if (this.properties.getId().isEmpty()) {
                return Component.translatable((String)"custommachinery.gui.creation.gui.id.missing");
            }
            return super.canCreate();
        }

        @Override
        public void addWidgets(GridLayout.RowHelper row) {
            this.addTexture(row, (Component)Component.translatable((String)"custommachinery.gui.creation.gui.texture"), this.properties::setTexture, this.baseElement == null ? SlotGuiElement.BASE_TEXTURE : ((SlotGuiElement)this.baseElement).getTexture());
            this.addId(row);
            this.addPriority(row);
            row.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"custommachinery.gui.creation.gui.slot.ghost"), this.font));
            this.ghostItem = (GhostItemWidget)row.addChild((LayoutElement)new GhostItemWidget());
            if (this.baseElement != null && ((SlotGuiElement)this.baseElement).getGhost() != GhostItem.EMPTY) {
                this.ghostItem.setGhost(((SlotGuiElement)this.baseElement).getGhost());
            }
        }
    }

    public static class GhostItemWidget
    extends GroupWidget {
        private final SuggestedEditBox items;
        private final Checkbox alwaysVisible;
        private final IntegerSlider transparency;
        private Color color = Color.TRANSPARENT_WHITE;

        public GhostItemWidget() {
            super(0, 0, 100, 60, (Component)Component.empty());
            this.items = this.addWidget(new SuggestedEditBox(Minecraft.getInstance().font, 0, 0, 100, 20, (Component)Component.empty(), 5));
            this.items.setMaxLength(Integer.MAX_VALUE);
            this.items.addSuggestions(BuiltInRegistries.ITEM.keySet().stream().map(ResourceLocation::toString).toList());
            this.alwaysVisible = this.addWidget(Checkbox.builder((Component)Component.empty(), (Font)Minecraft.getInstance().font).pos(80, 22).selected(false).build());
            this.alwaysVisible.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.gui.slot.ghost.alwaysVisible")));
            this.transparency = this.addWidget(IntegerSlider.builder().displayOnlyValue().bounds(0, 100).defaultValue(100).setResponder(value -> {
                this.color = Color.fromColors((int)((float)value.intValue() * 2.55f), this.color.getRed(), this.color.getGreen(), this.color.getBlue());
            }).create(0, 43, 100, 20, (Component)Component.translatable((String)"custommachinery.gui.creation.gui.slot.ghost.transparency", (Object[])new Object[]{100})));
            for (int i = 0; i < 16; ++i) {
                ChatFormatting format = ChatFormatting.getById((int)i);
                if (format == null) continue;
                String name = format.getName();
                WidgetSprites sprites = new WidgetSprites(CustomMachinery.rl("creation/style/" + name), CustomMachinery.rl("creation/style/" + name + "_selected"));
                ImageButton button = new ImageButton(i % 8 * 10 - 1, (i < 8 ? 0 : 10) + 22, 10, 10, sprites, b -> {
                    this.color = format.getColor() != null ? Color.fromARGB(this.color.getAlpha() << 24 | format.getColor()) : Color.WHITE;
                });
                this.addWidget(button);
                button.setTooltip(Tooltip.create((Component)Component.translatable((String)format.getName()).withStyle(format)));
            }
        }

        public void setGhost(GhostItem ghost) {
            if (ghost.ingredient().getItems().length != 0) {
                this.items.setValue(BuiltInRegistries.ITEM.getKey((Object)ghost.ingredient().getItems()[0].getItem()).toString());
            }
            this.items.hideSuggestions();
            if (ghost.alwaysRender() != this.alwaysVisible.selected()) {
                this.alwaysVisible.onPress();
            }
            this.transparency.setValue((int)((float)ghost.color().getAlpha() / 255.0f * 100.0f));
            this.color = ghost.color();
        }

        public GhostItem getGhost() {
            try {
                return new GhostItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)this.items.getValue()))}), this.color, this.alwaysVisible.selected());
            }
            catch (NullPointerException | ResourceLocationException e) {
                return GhostItem.EMPTY;
            }
        }

        @Override
        protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            ClientHandler.blit(graphics, SlotGuiElement.BASE_TEXTURE, this.getX() - 20, this.getY(), 18, 18);
            try {
                FakeItemRenderer.render(graphics, ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)this.items.getValue()))).getDefaultInstance(), this.getX() - 19, this.getY() + 1, this.color.getARGB());
            }
            catch (NullPointerException | ResourceLocationException throwable) {
                // empty catch block
            }
            RenderSystem.enableDepthTest();
            super.renderWidget(graphics, mouseX, mouseY, partialTick);
        }
    }
}

