/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.upgrade;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.upgrade.CreateUpgradePopup;
import fr.frinn.custommachinery.client.screen.creation.upgrade.DeleteUpgradePopup;
import fr.frinn.custommachinery.client.screen.creation.upgrade.UpgradeListSorting;
import fr.frinn.custommachinery.client.screen.creation.upgrade.UpgradeListWidget;
import fr.frinn.custommachinery.common.config.CMConfig;
import java.io.File;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;

public class UpgradeCreationScreen
extends BaseScreen {
    private CycleButton<UpgradeListSorting> sorter;
    private UpgradeListWidget upgradeList;
    private Button create;
    private Button edit;
    private Button open;
    private Button delete;

    public UpgradeCreationScreen() {
        super((Component)Component.literal((String)"Upgrade creation"), 256, 192);
    }

    public void sort(UpgradeListSorting sorting) {
        CMConfig.CONFIG.sortUpgradeList.set((Object)sorting);
        CMConfig.CONFIG.sortUpgradeList.save();
        this.upgradeList.sort();
    }

    public void create() {
        this.openPopup(new CreateUpgradePopup(this), "Creation popup");
    }

    public void edit() {
    }

    public void open() {
        UpgradeListWidget.UpgradeEntry entry = (UpgradeListWidget.UpgradeEntry)this.upgradeList.getSelected();
        if (entry != null) {
            try {
                File file = Objects.requireNonNull(entry.getLocation().getFile((MinecraftServer)Minecraft.getInstance().getSingleplayerServer()));
                Util.getPlatform().openUri(file.toURI());
            }
            catch (NullPointerException e) {
                CustomMachinery.LOGGER.warn("Can't open upgrade json for upgrade: {}", (Object)entry.getLocation().id());
            }
        }
    }

    public void delete() {
        UpgradeListWidget.UpgradeEntry entry = (UpgradeListWidget.UpgradeEntry)this.upgradeList.getSelected();
        if (entry != null) {
            this.openPopup(new DeleteUpgradePopup((BaseScreen)this, entry.getLocation(), entry.getUpgrade()), "Delete upgrade");
        }
    }

    public void reloadList() {
        this.upgradeList.reload();
    }

    @Override
    protected void init() {
        super.init();
        GridLayout layout = new GridLayout(this.x, this.y);
        layout.defaultCellSetting().padding(5);
        GridLayout.RowHelper row = layout.createRowHelper(4);
        LayoutSettings center = row.newCellSettings().alignHorizontallyCenter();
        this.sorter = (CycleButton)row.addChild((LayoutElement)CycleButton.builder(v -> Component.literal((String)v.name())).withValues((Object[])UpgradeListSorting.values()).displayOnlyValue().withInitialValue((Object)((UpgradeListSorting)((Object)CMConfig.CONFIG.sortUpgradeList.get()))).create(0, 0, 50, 20, (Component)Component.empty(), (button, sort) -> this.sort((UpgradeListSorting)((Object)sort))), 4, row.newCellSettings().alignHorizontallyLeft().paddingBottom(0));
        this.upgradeList = (UpgradeListWidget)row.addChild((LayoutElement)new UpgradeListWidget(0, 0, this.xSize - 10, this.ySize - 65, 30), 4, center);
        this.upgradeList.reload();
        this.create = (Button)row.addChild((LayoutElement)new Button.Builder((Component)Component.translatable((String)"custommachinery.gui.creation.create"), button -> this.create()).bounds(0, 0, 50, 20).build(), center);
        this.edit = (Button)row.addChild((LayoutElement)new Button.Builder((Component)Component.translatable((String)"custommachinery.gui.creation.edit"), button -> this.edit()).bounds(0, 0, 50, 20).build(), center);
        this.open = (Button)row.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"custommachinery.gui.creation.open"), button -> this.open()).bounds(0, 0, 50, 20).build(), center);
        this.delete = (Button)row.addChild((LayoutElement)new Button.Builder((Component)Component.translatable((String)"custommachinery.gui.creation.delete"), button -> this.delete()).bounds(0, 0, 50, 20).build(), center);
        layout.arrangeElements();
        layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(graphics, mouseX, mouseY, partialTick);
        UpgradeCreationScreen.blankBackground(graphics, this.x, this.y, this.xSize, this.ySize);
        UpgradeListWidget.UpgradeEntry entry = (UpgradeListWidget.UpgradeEntry)this.upgradeList.getSelected();
        if (entry == null) {
            Tooltip notSelected = Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.upgrade.not_selected"));
            this.edit.active = false;
            this.edit.setTooltip(notSelected);
            this.open.active = false;
            this.open.setTooltip(notSelected);
            this.delete.active = false;
            this.delete.setTooltip(notSelected);
            return;
        }
        if (entry.getLocation().canEdit()) {
            this.edit.active = true;
            this.edit.setTooltip(null);
            if (Minecraft.getInstance().getSingleplayerServer() != null) {
                this.open.active = true;
                this.open.setTooltip(null);
            } else {
                this.open.active = false;
                this.open.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.upgrade.cant_open_server")));
            }
            this.delete.active = true;
            this.delete.setTooltip(null);
        } else {
            this.edit.active = false;
            this.edit.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.upgrade.cant_edit")));
            this.open.active = false;
            this.open.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.upgrade.cant_open")));
            this.delete.active = false;
            this.delete.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinery.gui.creation.upgrade.cant_delete")));
        }
        this.edit.active = false;
        this.edit.setTooltip(Tooltip.create((Component)Component.literal((String)"WIP")));
    }
}

