/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.popup;

import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public class ConfirmPopup
extends PopupScreen {
    public static final Component CONFIRM = Component.translatable((String)"custommachinery.gui.popup.confirm").withStyle(ChatFormatting.GREEN);
    public static final Component CANCEL = Component.translatable((String)"custommachinery.gui.popup.cancel").withStyle(ChatFormatting.RED);
    private final Runnable onConfirm;
    private final List<Component> text = new ArrayList<Component>();
    private Component title;
    @Nullable
    private Runnable onCancel;

    public ConfirmPopup(BaseScreen parent, int xSize, int ySize, Runnable onConfirm) {
        super(parent, xSize, ySize);
        this.onConfirm = onConfirm;
        this.onCancel = null;
    }

    public ConfirmPopup cancelCallback(Runnable callback) {
        this.onCancel = callback;
        return this;
    }

    public ConfirmPopup title(Component title) {
        this.title = title;
        return this;
    }

    public ConfirmPopup text(Component ... components) {
        this.text.addAll(Arrays.asList(components));
        return this;
    }

    public void confirm() {
        this.onConfirm.run();
        this.parent.closePopup(this);
    }

    public void cancel() {
        if (this.onCancel != null) {
            this.onCancel.run();
        }
        this.parent.closePopup(this);
    }

    @Override
    protected void init() {
        super.init();
        GridLayout layout = new GridLayout(this.x, this.y);
        GridLayout.RowHelper row = layout.createRowHelper(2);
        row.defaultCellSetting().paddingTop(5);
        if (this.title != null) {
            row.addChild((LayoutElement)new StringWidget(this.xSize, 10, this.title, Minecraft.getInstance().font).alignCenter(), 2);
        }
        if (!this.text.isEmpty()) {
            MutableComponent text = Component.empty();
            for (Component component : this.text) {
                text.append("\n").append(component);
            }
            MultiLineTextWidget textWidget = new MultiLineTextWidget((Component)text, Minecraft.getInstance().font).setCentered(true).setMaxWidth(this.xSize - 10);
            this.ySize = textWidget.getHeight() + 50;
            row.addChild((LayoutElement)textWidget, 2, row.newCellSettings().alignHorizontallyCenter());
        }
        row.addChild((LayoutElement)Button.builder((Component)CONFIRM, b -> this.confirm()).bounds(0, 0, 50, 20).build(), row.newCellSettings().alignHorizontallyCenter());
        row.addChild((LayoutElement)Button.builder((Component)CANCEL, b -> this.cancel()).bounds(0, 0, 50, 20).build(), row.newCellSettings().alignHorizontallyCenter());
        layout.arrangeElements();
        layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }
}

