/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.widget;

import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;

public class IntegerEditBox
extends EditBox {
    private int max = Integer.MAX_VALUE;
    private int min = Integer.MIN_VALUE;

    public IntegerEditBox(Font font, int x, int y, int width, int height, Component message) {
        super(font, x, y, width, height, message);
        this.setFilter(s -> true);
    }

    public void bounds(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public int getIntValue() {
        if (this.getValue().isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(this.getValue());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public void setIntValue(int value) {
        this.setValue("" + value);
    }

    public void setIntResponder(Consumer<Integer> responder) {
        this.setResponder(s -> {
            try {
                responder.accept(Integer.parseInt(s));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
    }

    public void setFilter(Predicate<String> validator) {
        super.setFilter(s -> {
            if (s.isEmpty()) {
                this.setValue("0");
                return true;
            }
            try {
                int value = Integer.parseInt(s);
                return value >= this.min && value <= this.max && validator.test((String)s);
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
    }
}

